library(ggplot2)
library(gridExtra)
library(plyr)
theme_set(theme_bw())

h<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/data/hot.txt")
c<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/data/cold.txt")
names(h)<- c("replicate","generation","chromosome","position","popfreq")
names(c)<- c("replicate","generation","chromosome","position","popfreq")

# convert chromosome to ordered factor
h$chromosome <- factor(h$chromosome, levels=c("X", "2L", "2R", "3L", "3R", "4"))
c$chromosome <- factor(c$chromosome, levels=c("X", "2L", "2R", "3L", "3R", "4"))
lim<-c(0,0.4)
ybreaks<-c(0,0.1, 0.2,0.3, 0.4)

pf.mean <- ddply(.data=h, 
                 .(generation,replicate),
                 summarize, 
                 mean= mean(popfreq))
pf.mean[pf.mean$mean<0,]$mean=0.0
pf.mean$mean=round(pf.mean$mean,digits=3)
pf.mean$n=paste("f = ",pf.mean$mean)

p<- ggplot(h,aes(x=popfreq))+geom_histogram(binwidth=0.01)+facet_grid(generation~replicate)+xlim(0.05,0.4)+xlab("population frequency")+
  geom_text(data=pf.mean,aes(x=0.3,y=30,label=n),size=6)
plot(p)
dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/graphs/hot-comp.eps")

