library(ggplot2)
library(gridExtra)
library(plyr)
theme_set(theme_bw())

h<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/03-significance/popfreq/hot.txt")
c<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/03-significance/popfreq/cold40.txt")
names(h)<- c("replicate","generation","chromosome","position","popfreq")
names(c)<- c("replicate","generation","chromosome","position","popfreq")



hm <- ddply(.data=h, 
                 .(generation,replicate),
                 summarize, 
                 mean= mean(popfreq))
#hm[hm$mean<0,]$mean=0.0

cm <- ddply(.data=c, 
            .(generation,replicate),
            summarize, 
            mean= mean(popfreq))
#cm[cm$mean<0,]$mean=0.0

mod1<-lmer(mean~ (1|replicate),hm)
mod2<-lmer(mean~generation+ (1|replicate),hm)
print(anova(mod1,mod2))

mod3<-lmer(mean~ (1|replicate),cm)
mod4<-lmer(mean~generation+ (1|replicate),cm)
print(anova(mod3,mod4))


