library(ggplot2)
theme_set(theme_bw())

d<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/01-microhomology/raw/resforR.txt")
names(d)<- c("sample","homo","pos")
levels(d$sample)[levels(d$sample)=="rand"] <- "random"
levels(d$sample)[levels(d$sample)=="real"] <- "data"

lin<-data.frame(x=c(0.0, 0.0),y=c(0.18,0.45))
g<-ggplot(d,aes(x=pos,y=homo,col=sample))+geom_line()+
  geom_line(data=lin,aes(x=x,y=y),linetype=2,col="black")+ylab("matings [count]")+ylim(0.18,0.45)+ylab("fraction of homologous bases")+xlab("position relative to deletion site")
  #theme(legend.title=element_blank())
  #geom_rect(aes(xmin=-2.5, xmax=1.5, ymin=0.18, ymax=0.45), color="lightgrey",alpha=0.005)
pdf("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/01-microhomology/microhomology.pdf",width=7,height=4)
plot(g)
dev.off()