library(ggplot2)
library(gridExtra)

# To use for fills, add
ls=0.8
pastelle <-c("#CC6666", "#9999CC", "#66CC99")
blackyellowgreen <- c("#000000", "#E69F00", "#009E73")
grayyellowgreen <- c("#999999", "#E69F00", "#009E73")
brewer1 <-c("#7fc97f","#beaed4","#fdc086")
brewer2 <-c("#666666","#a6761d","#66a61e")
final2 <- c("green", "yellow", "grey")
greyscale<-c("#969696","#636363","#252525")
greenscale<-c("#74c476","#31a354","#006d2c")

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
cbbPalette <- fuckit



################ count ##################################

hc<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/tc15/unfiltered/hot.txt")
cc<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/tc15/unfiltered/cold.txt")
names(hc)<- c("replicate","generation","chromosome","position")
names(cc)<- c("replicate","generation","chromosome","position")
cc$count=1
hc$count=1
hc$replicate<-as.factor(hc$replicate)
cc$replicate<-as.factor(cc$replicate)


hca<-aggregate(count~generation+replicate,data=hc,FUN=length)
cca<-aggregate(count~generation+replicate,data=cc,FUN=length)
maxcount=max(c(max(hca$count),max(cca$count)))


#ghc<-ggplot(hca,aes(x=generation,y=count,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxcount) +
#  theme(legend.position="none",axis.title.x=element_blank(),axis.text.x=element_blank())+ scale_colour_manual(values=cbbPalette)

#gtc<-ggplot(tc,aes(x=generations,y=count,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxcount) + 
#  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank())+
 # scale_x_continuous(breaks=c(0,10,20))+scale_colour_manual(values=cbbPalette)

#gcc<-ggplot(cca,aes(x=generation,y=count,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxcount) + 
#  theme(legend.position="none",axis.title.x=element_blank(),axis.text.x=element_blank(),axis.title.y=element_blank(),axis.text.y=element_blank())+scale_colour_manual(values=cbbPalette)


 

################## FREQUENCY

hf<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/tc15/filtered/hot.txt")
cf<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/tc15/filtered/cold.txt")
names(hf)<- c("replicate","generation","chromosome","position","popfreq")
names(cf)<- c("replicate","generation","chromosome","position","popfreq")
hf$replicate<-as.factor(hf$replicate)
cf$replicate<-as.factor(cf$replicate)
cf$count=1
hf$count=1

# filter low freq

hlf<-hf[hf$popfreq<0.08,]
clf<-cf[cf$popfreq<0.08,]


hclf<-aggregate(count~generation+replicate,data=hlf,FUN=length)
cclf<-aggregate(count~generation+replicate,data=clf,FUN=length)


lphf<-ggplot(hclf,aes(x=generation,y=count,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0.0,100) +
  theme(legend.position="none")+ scale_colour_manual(values=cbbPalette)+ylab("count f<0.10")
lpcf<-ggplot(cclf,aes(x=generation,y=count,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0.0,100)+
  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank())+ scale_colour_manual(values=cbbPalette)




grid.arrange(lphf,lpcf,ncol=2,nrow=1,widths=c(3,2))

dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/graph/lf-invasion.eps")
