library(ggplot2)
library(gridExtra)

theme_set(theme_bw())
ls=0.8
fuckit<-c("#e41a1c","#377eb8","#4daf4a")
cbbPalette <- fuckit
s<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-07-rpm/data/isofemale-invasion.txt")
names(s)<-c("line","generation","rpm-uc","rpm")
s$line<-as.factor(s$line)



p<-ggplot(s,aes(x=generation,y=rpm,color=line))+geom_line(size=ls)+geom_point() + 
  theme(legend.position=c(0.1,0.7)) +
  geom_hline(yintercept=287,linetype="dashed",colour="#e41a1c")+
  geom_hline(yintercept=251,linetype="dashed",colour="#377eb8")+
  geom_hline(yintercept=295,linetype="dashed",colour="#4daf4a")+
  annotate("text", x = 0.0, y = 320, label = "hot 1",color="#e41a1c",size=5)+
  annotate("text", x = 0.0, y = 230, label = "hot 3",color="#377eb8",size=5)+
  annotate("text", x = 0.15, y = 320, label = "hot 5",color="#4daf4a",size=5)+
  scale_x_continuous(breaks=c(0,1,2),labels=c("2010 (Oct)","2012 (Aug)","2015 (Sep)"))+ xlab("date")
plot(p)

dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-07-rpm/graphs/isofemale-line-invasion.eps")
