library(ggplot2)
library(gridExtra)

# To use for fills, add
ls=0.8
pastelle <-c("#CC6666", "#9999CC", "#66CC99")
blackyellowgreen <- c("#000000", "#E69F00", "#009E73")
grayyellowgreen <- c("#999999", "#E69F00", "#009E73")
brewer1 <-c("#7fc97f","#beaed4","#fdc086")
brewer2 <-c("#666666","#a6761d","#66a61e")
final2 <- c("green", "yellow", "grey")
greyscale<-c("#969696","#636363","#252525")
greenscale<-c("#74c476","#31a354","#006d2c")

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
cbbPalette <- fuckit

hr<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/rpm/hot-rpm.txt",header=T)
cr<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/rpm/cold-rpm.txt",header=T)
hr$replicate<-as.factor(hr$replicate)
cr$replicate<-as.factor(cr$replicate)


hs<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/speed/hot-speed.txt",header=T)
cs<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/speed/cold-speed.txt",header=T)
hs$replicate<-as.factor(hs$replicate)
cs$replicate<-as.factor(cs$replicate)




theme_set(theme_bw())

maxrpm=max(hr$rpm)
minspeed=min(c(min(hs$u),min(cs$u)))
maxspeed=max(c(max(hs$u),max(cs$u)))

##### RPM

ghr<-ggplot(hr,aes(x=generations,y=rpm,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxrpm) + 
  theme(legend.position=c(0.85,0.4),axis.title.x=element_blank(),axis.text.x=element_blank()) + annotate("text", x = 2, y = 3800, label = "hot",size=8,color="black")+
  scale_colour_manual(values=cbbPalette)

# gtr<-ggplot(tr,aes(x=generations,y=rpm,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxrpm) + 
#  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank(),axis.title.x=element_blank(),axis.text.x=element_blank())+
#  scale_x_continuous(breaks=c(0,10,20)) + annotate("text", x = 4, y = 3800, label = "hot",size=8,color="red")+ scale_colour_manual(values=cbbPalette)

gcr<-ggplot(cr,aes(x=generations,y=rpm,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxrpm) +
  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank(),axis.title.x=element_blank(),axis.text.x=element_blank())+ annotate("text", x = 4, y = 3800, label = "cold",color="black",size=8)+
  scale_colour_manual(values=cbbPalette)

################## speed ###############################
ghs<-ggplot(hs,aes(x=generations,y=u,color=replicate))+geom_line(size=ls)+geom_point()+
  theme(legend.position="none",axis.title.x=element_blank(),axis.text.x=element_blank())+ scale_colour_manual(values=cbbPalette)+
  ylab("u*")+scale_y_continuous(breaks=c(0,0.1,0.2),limits=c(minspeed,maxspeed))

#gts<-ggplot(ts,aes(x=generations,y=u,color=replicate))+geom_line(size=ls)+geom_point()+ylim(minspeed,maxspeed) + 
#  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank(),axis.title.x=element_blank(),axis.text.x=element_blank())+
#  scale_x_continuous(breaks=c(0,10,20))+scale_colour_manual(values=cbbPalette)

gcs<-ggplot(cs,aes(x=generations,y=u,color=replicate))+geom_line(size=ls)+geom_point()+ylim(minspeed,maxspeed) + 
  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank(),axis.title.x=element_blank(),axis.text.x=element_blank())+scale_colour_manual(values=cbbPalette)


################ count ##################################

hc<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/tc15/unfiltered/hot.txt")
cc<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/tc15/unfiltered/cold.txt")
names(hc)<- c("replicate","generation","chromosome","position")
names(cc)<- c("replicate","generation","chromosome","position")
cc$count=1
hc$count=1
hc$replicate<-as.factor(hc$replicate)
cc$replicate<-as.factor(cc$replicate)


hca<-aggregate(count~generation+replicate,data=hc,FUN=length)
cca<-aggregate(count~generation+replicate,data=cc,FUN=length)
maxcount=max(c(max(hca$count),max(cca$count)))


ghc<-ggplot(hca,aes(x=generation,y=count,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxcount) +
  theme(legend.position="none",axis.title.x=element_blank(),axis.text.x=element_blank())+ scale_colour_manual(values=cbbPalette)

#gtc<-ggplot(tc,aes(x=generations,y=count,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxcount) + 
#  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank())+
 # scale_x_continuous(breaks=c(0,10,20))+scale_colour_manual(values=cbbPalette)

gcc<-ggplot(cca,aes(x=generation,y=count,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,maxcount) + 
  theme(legend.position="none",axis.title.x=element_blank(),axis.text.x=element_blank(),axis.title.y=element_blank(),axis.text.y=element_blank())+scale_colour_manual(values=cbbPalette)



################## FREQUENCY

hf<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/tc15/filtered/hot.txt")
cf<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/tc15/filtered/cold.txt")
names(hf)<- c("replicate","generation","chromosome","position","popfreq")
names(cf)<- c("replicate","generation","chromosome","position","popfreq")
hf$replicate<-as.factor(hf$replicate)
cf$replicate<-as.factor(cf$replicate)

hfa<-aggregate(popfreq~generation+replicate,data=hf,FUN=mean)
cfa<-aggregate(popfreq~generation+replicate,data=cf,FUN=mean)

lphf<-ggplot(hfa,aes(x=generation,y=popfreq,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0.07,0.13) +
  theme(legend.position="none")+ scale_colour_manual(values=cbbPalette)+ylab("av. pop. freq.")
lpcf<-ggplot(cfa,aes(x=generation,y=popfreq,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0.07,0.13)+
  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank())+ scale_colour_manual(values=cbbPalette)




grid.arrange(ghr,gcr,ghs,gcs,ghc,gcc,lphf,lpcf,ncol=2,nrow=4,widths=c(3,2),heights=c(1,0.5,1,1))

dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-invasiongraph/graph/main-graph.eps")
