library(ggplot2)
library(gridExtra)

# To use for fills, add
ls=0.8
pastelle <-c("#CC6666", "#9999CC", "#66CC99")
blackyellowgreen <- c("#000000", "#E69F00", "#009E73")
grayyellowgreen <- c("#999999", "#E69F00", "#009E73")
brewer1 <-c("#7fc97f","#beaed4","#fdc086")
brewer2 <-c("#666666","#a6761d","#66a61e")
final2 <- c("green", "yellow", "grey")
greyscale<-c("#969696","#636363","#252525")
greenscale<-c("#74c476","#31a354","#006d2c")

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
grey<-c("#a1a1a1","#5e5e5e","#3c3c3c")
cbbPalette <- grey

theme_set(theme_bw())
t<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-07-rpm/data/raw-invasion-extended.txt",na.strings = "na")
names(t)<-c("condition","replicate","generation","femmale","count","uc-rpm","rpm","u")
t$condition <- factor(t$condition, levels=c("hot", "cold"))
t$replicate<-as.factor(t$replicate)







##### RPM

p<-ggplot(t,aes(x=generation,y=rpm,color=replicate))+geom_line(size=ls)+geom_point() +facet_grid(~condition,scales="free_x", space = "free_x")+ 
  theme(legend.position=c(0.5,0.3),axis.title.x=element_blank(),axis.text.x=element_blank()) +
  scale_colour_manual(values=cbbPalette)

### u
minspeed=min(t$u,na.exclude=T)
maxspeed=max(t$u,na.exclude=T)
ts<-t
ts$generation<-ts$generation-10
ts<-subset(ts,ts$generation>=0)
ts<-rbind(subset(t,!is.na(t$u)),ts)


s<-ggplot(ts,aes(x=generation,y=u,color=replicate))+geom_line(size=ls)+geom_point()+facet_grid(~condition,scales="free_x", space = "free_x")+
  theme(strip.text=element_blank(),legend.position="none")+scale_colour_manual(values=cbbPalette)+
  ylab("u")+scale_y_continuous(breaks=c(0,0.1,0.2),limits=c(minspeed,maxspeed))



postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-07-rpm/graphs/main-graph-grey-rpm.ps",width=5.5,height=3.8)

grid.arrange(p,s,ncol=1,nrow=2,heights=c(1,0.5))

dev.off()