library(ggplot2)
library(gridExtra)

# To use for fills, add
ls=0.8
pastelle <-c("#CC6666", "#9999CC", "#66CC99")
blackyellowgreen <- c("#000000", "#E69F00", "#009E73")
grayyellowgreen <- c("#999999", "#E69F00", "#009E73")
brewer1 <-c("#7fc97f","#beaed4","#fdc086")
brewer2 <-c("#666666","#a6761d","#66a61e")
final2 <- c("green", "yellow", "grey")
greyscale<-c("#969696","#636363","#252525")
greenscale<-c("#74c476","#31a354","#006d2c")

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
cbbPalette <- fuckit

theme_set(theme_bw())
t<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-07-rpm/data/old/raw-invasion-c60.txt")
names(t)<-c("condition","replicate","generation","count","uc-rpm","rpm")
t$condition <- factor(t$condition, levels=c("hot", "cold"))
t$replicate<-as.factor(t$replicate)







##### RPM

p<-ggplot(t,aes(x=generation,y=rpm,color=replicate))+geom_line(size=ls)+geom_point() +facet_grid(~condition,scales="free_x", space = "free_x")+ 
  theme(legend.position=c(0.5,0.2)) +
  scale_colour_manual(values=cbbPalette)





plot(p)

dev.copy2eps(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-07-rpm/graphs/main-graph-rpm-c60.eps")
