library(ggplot2)
library(gridExtra)
library(plyr)
theme_set(theme_bw())


fico <- c("red", "yellow", "green")
fico2<-c("#1a9850","#fee08b","#d73027")
fico3<-c("#91cf60","#ffffbf","#fc8d59")
fico4<-c("#1a9641","#ffffbf","#d7191c")
fico5<-c("#1a9850","#ffffbf","#d73027")
fico6<-c("#f46d43","#ffffbf","#66bd63")

t<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-09-HybridDysgenesis/rawforr.R")
names(t)<-c("temp","rep","hd","pc","pcf")

t$temp <- factor(t$temp, levels=c("29", "28", "20"))
t$temp<-mapvalues(t$temp, from = c("29", "28","20"), to = c("29 C", "28-18 C","20-10 C"))

t$rep <- factor(t$rep, levels=c("H1", "H3", "H5","C1", "C3", "C5"))
t$hd <- factor(t$hd, levels=c("absence", "weak","normal"))


g<-ggplot(t,aes(x=rep,y=pcf,fill=hd))+geom_bar(stat="identity")+facet_grid(temp~.)+scale_fill_manual(values=fico6)+
  theme(legend.position="none")+xlab("replicate")+ylab("percent")
plot(g)

postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-09-HybridDysgenesis/hd-plot.ps",width=2.7,height=3.5)
plot(g)
dev.off()