library(ggplot2)
library(RColorBrewer)
theme_set(theme_bw())

b<-brewer.pal(12,"Paired")
fuckit<-c("grey50","#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#a65628","#f781bf")
cbbPalette<-fuckit

t<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/data/truncpositions/finaldata/sumfirst.forR")
# hot	1	60	2L	19789989	P-element	0.023	0
# hot	1	60	2L	2823313	P-element	0.101	0
# hot	1	60	2L	19102234	P-element	0.021	0

names(t)<-c("condition","replicate","generation","chromosome","position","family","popfreq","truncated")
t$chromosome <- factor(t$chromosome, levels=c("X", "2L", "2R", "3L", "3R", "4"))
t$size=0.5
t[t$truncated==1,]$size<-0.6
lim<-c(0.0,0.35)
ybreaks<-c(0,0.1, 0.2,0.3, 0.4,0.5)

t$truncated=as.factor(t$truncated)
t$replicate=as.factor(t$replicate)

tp<- ggplot(t,aes(x=position,y=popfreq,color=truncated))+geom_point(aes(size=size))+facet_grid(replicate~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",lim=lim,breaks=ybreaks)+scale_colour_manual(values=cbbPalette)+
  scale_size(range = c(0.5, 1.5))+theme(legend.position="none")


g<-ggplot(t,aes(x=truncated,y=popfreq))+geom_boxplot()+facet_grid(.~replicate)
postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/graphs/trunc-mhp.ps",width=10,height=8)
plot(tp)
dev.off()
