library(ggplot2)
library(gridExtra)

# To use for fills, add
ls=0.8
pastelle <-c("#CC6666", "#9999CC", "#66CC99")
blackyellowgreen <- c("#000000", "#E69F00", "#009E73")
grayyellowgreen <- c("#999999", "#E69F00", "#009E73")
brewer1 <-c("#7fc97f","#beaed4","#fdc086")
brewer2 <-c("#666666","#a6761d","#66a61e")
final2 <- c("green", "yellow", "grey")
greyscale<-c("#969696","#636363","#252525")
greenscale<-c("#74c476","#31a354","#006d2c")

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
cbbPalette <- greyscale

theme_set(theme_bw())
t<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2017-05/data.txt")
names(t)<-c("generation","replicate","avfreq")

t$replicate<-as.factor(t$replicate)







##### RPM

p<-ggplot(t,aes(x=generation,y=avfreq,color=replicate))+geom_line(size=ls)+geom_point() + 
  theme(legend.position="none") +xlim(0,60)+
  scale_colour_manual(values=cbbPalette)





plot(p)

dev.copy2eps(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2017-05/graph.eps")
