library(ggplot2)
library(gridExtra)

# To use for fills, add
ls=0.8
pastelle <-c("#CC6666", "#9999CC", "#66CC99")
blackyellowgreen <- c("#000000", "#E69F00", "#009E73")
grayyellowgreen <- c("#999999", "#E69F00", "#009E73")
brewer1 <-c("#7fc97f","#beaed4","#fdc086")
brewer2 <-c("#666666","#a6761d","#66a61e")
final2 <- c("green", "yellow", "grey")
greyscale<-c("#969696","#636363","#252525")
greenscale<-c("#74c476","#31a354","#006d2c")

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
rb<-c("red","blue")
cbbPalette <- rb

theme_set(theme_bw())
t<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-07-rpm/data/rnaseq.txt")
names(t)<-c("evolved","replicate","common_garden","rpm")
levels(t$evolved)[levels(t$evolved)=="hot"]<-"hot evolved; gen. 22"
levels(t$evolved)[levels(t$evolved)=="cold"]<-"cold evolved; gen. 11"
t$replicate<-as.factor(t$replicate)
#levels(t$replicate)[levels(t$replicate)=="8"]<-"a"
#levels(t$replicate)[levels(t$replicate)=="9"]<-"b"
#levels(t$replicate)[levels(t$replicate)=="10"]<-"c"

t$evolved <- factor(t$evolved, levels=c("hot evolved; gen. 22", "cold evolved; gen. 11"))
t$common_garden <- factor(t$common_garden, levels=c("hot", "cold"))








##### RPM

p<-ggplot(t,aes(y=rpm,fill=common_garden,x=replicate))+geom_bar(position="dodge",stat="identity")+
  scale_fill_manual(values=cbbPalette)+theme(legend.position=c(0.9,0.8))+facet_grid(.~evolved)

#+geom_line(size=ls)+geom_point() +facet_grid(~condition,scales="free_x", space = "free_x")+ 
#  +
#  scale_colour_manual(values=cbbPalette)




postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-07-rpm/graphs/expression.ps",width=4.5,height=3.7)
plot(p)
dev.off()

#dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-07-rpm/graphs/rna-seq-large.eps")
