import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

import truncations


def load_truncs(file):
     truncset=set([])
     for l in open(file):
          """
          FCC577TACXX:3:2107:21175:32927#CGATGTAT437	547-2722
          FCC577TACXX:1:1101:20747:41039#CGATGTAT563	696-2282
          FCC577TACXX:3:2213:7624:55891#CGATGTAT1038	973-1211
          """
          a=l.rstrip("\n").split("\t")
          rn=a[0]
          rn=re.sub(r"#.*","",rn)
          truncset.add(rn)
     return truncset
          


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--sam', type=argparse.FileType('r'), default=None,dest="sam", required=True, help="A sam file")
parser.add_argument("--truncnames", type=str, required=True, dest="truncnames", help="The names of truncated reads bound")
args = parser.parse_args()

truncset=load_truncs(args.truncnames)
euchr=set(["X","2L","2R","3L","3R","4"])


for l in args.sam:
     """
     FCC577TACXX:3:2206:17921:91863#CGATGTAT	129	contig_3214	2	0	23S77M	contig_296	3789	0	TTAAAGTGTCATCAGCAGAAATACATCGAAGATTAAATAGACGGCAAAAGAAAAAAGATGAGAGTTTCCATAATTTCTTGTACGCACTGATGGAAATAGC	abbeeeceeggggiiiiiiihihhiiiiiiihiiiiiihhfgiihiiiiifhiiiihhigfgggceeeeeeedddddddcccdcccccccbccccbbccc	AS:i:77
     """
     l=l.rstrip("\n")
     a=l.split("\t")
     rn=a[0]
     rn=re.sub(r"#.*","",rn)
     chrom=a[2]
     if(rn in truncset and chrom in euchr):
          print l
     
     

