import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

import truncations


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--sam', type=argparse.FileType('r'), default=None,dest="sam", required=True, help="A sam file")
parser.add_argument("--bound", type=int, required=False, dest="bound",default=100, help="The coverage bound")
parser.add_argument("--rep", type=str, required=True, dest="rep", help="The replicate")
parser.add_argument("--gen", type=str, required=True, dest="gen", help="The generation")
args = parser.parse_args()


s=truncations.PTruncSamEntry.load(args.sam)
avc=s.get_averagecoverage(int(args.bound))
truncs=s.get_truncations()

tc=collections.defaultdict(lambda:0)
for t in truncs:
	tc[t]+=1
	
rep=args.rep
gen=args.gen

#print("Av.cov: {0}".format(avc))
for t,c in tc.items():
	freq=float(c)/avc
	print "{0}\t{1}\t{2}\t{3}\t{4}\t{5}".format(rep,gen,t[0],t[1],c,freq)

