import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

import truncations

def load_truncset(file):
     th=set([])
     for l in open(file):
          l=l.rstrip("\n").split("\t")
          rn=l[0]
          rn=re.sub("#.*","",rn)
          th.add(rn)
     return th


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--trunc', type=str, default=None,dest="trunc", required=True, help="A sam file")
parser.add_argument('--sam', type=argparse.FileType('r'), default=None,dest="sam", required=True, help="A sam file")
args = parser.parse_args()

echr=set(["X","2L","2R","3L","3R","4"])

th=load_truncset(args.trunc)

for r in args.sam:
     r=r.strip("\n")
     t=r.split("\t")
     rn=t[0]
     chr=t[2]
     if chr not in echr:
          continue
     rn=re.sub("#.*","",rn)
     if rn in th:
          print(r)

