import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

import truncations


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--sam', type=argparse.FileType('r'), default=None,dest="sam", required=True, help="A sam file")
args = parser.parse_args()


s=truncations.PTruncSamEntry.load(args.sam)

for t in s.get_truncation_reads():
     truncs=t.get_truncations()
     toj=[]
     for s,e in truncs:
          toj.append("{0}-{1}".format(s,e))
     trs=",".join(toj)
     print "{0}\t{1}".format(t.readname(),trs)

