import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

from truncationobject import *


def getsetcount(key,sets):
    c=0
    for s in sets.values():
        if key in s:
            c+=1
    return c

parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--hot', type=str, required=True, dest="hot", help="Truncations in hot conditions")
parser.add_argument("--cold", type=str, required=True, dest="cold", help="Truncations in cold conditions")
parser.add_argument("--output", type=str, required=True, dest="output", help="Output, truncations likely being present at start of experiment")
args = parser.parse_args()

hot=TruncationReader.readall(args.hot)
cold=TruncationReader.readall(args.cold)


presentinbase={}
truncsets=collections.defaultdict(lambda:set([]))

for h in hot:
    k=h.key
    rep="h"+h.replicate
    truncsets[rep].add(k)
    if h.generation==0:
        presentinbase[k]=h

for c in cold:
    k=c.key
    rep="c"+c.replicate
    truncsets[rep].add(k)
    if c.generation==0:
        presentinbase[k]=c
        

for h in hot:
    k=h.key
    count=getsetcount(k,truncsets)
    if(count>=2):
        presentinbase[k]=h

for c in cold:
    k=c.key
    count=getsetcount(k,truncsets)
    if(count>=2):
        presentinbase[k]=c
        



TruncationWriter.writeall(args.output,presentinbase.values())


