import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

from truncationobject import *


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--data', type=str, required=True, dest="data", help="Data")
args = parser.parse_args()


data=TruncationReader.readall(args.data)
weighdict=collections.defaultdict(lambda:0.0)

for d in data:
     key=d.key
     freq=d.popfreq
     start,end=[int(i) for i in key.split("-")]
     for i in range(start,end+1):
          testcov=weighdict[i]+freq
          weighdict[i]=testcov


for i in range(1,2908):
     weigh=weighdict[i]
     print "{0}\t{1}".format(i,weigh)
     







