import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

from truncationobject import *


def print_trajectories(truncations,prefix,generations):
     dict=collections.defaultdict(lambda:collections.defaultdict(lambda:{}))
     for t in truncations:
          r=t.replicate
          r=r.lstrip("r")
          dict[r][t.key][t.generation]=t.popfreq
     
     for replicate,tmp1 in dict.items():
          for key,tmp2 in tmp1.items():
               started=False
               for g in generations:
                    freq=0.0
                    if g in tmp2:
                         freq = tmp2[g]
                    print "{0}\t{1}\t{2}\t{3}\t{4}".format(prefix,replicate,key,g,freq)
                         
                    
     


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--hot', type=str, required=True, dest="hot", help="Truncations in hot conditions")
parser.add_argument("--cold", type=str, required=True, dest="cold", help="Truncations in cold conditions")


args = parser.parse_args()

# levels: replicate - key - generations


hotl=TruncationReader.readall(args.hot)
coldl=TruncationReader.readall(args.cold)

print_trajectories(hotl,"hot",[0,10,20,30,40,50,60])
print_trajectories(coldl,"cold",[0,10,20,30,40])


