import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

from truncationobject import *



parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--hot', type=str, required=True, dest="hot", help="Truncations in hot conditions")
parser.add_argument("--cold", type=str, required=True, dest="cold", help="Truncations in cold conditions")
parser.add_argument("--base", type=str, required=True, dest="base", help="Truncations present in base population")

args = parser.parse_args()

hotl=TruncationReader.readall(args.hot)
coldl=TruncationReader.readall(args.cold)
base=TruncationReader.readall(args.base)
basekeyset=set([t.key for t in base])


hot={}
cold={}

for h in hotl:
	k=h.key
	present=0
	if k in basekeyset:
		present=1
	hot[k]=["hot",h.start,h.end,h.key,present,h.end-h.start]
	

for c in coldl:
	k=c.key
	present=0
	if k in basekeyset:
		present=1
	cold[k]=["cold",c.start,c.end,c.key,present,c.end-c.start]

hotnum=1;
for v in sorted(hot.values(),key=lambda i:-i[5]):
	s="\t".join([v[0],str(hotnum),str(v[1]),str(v[3]),str(v[4])])
	e="\t".join([v[0],str(hotnum),str(v[2]),str(v[3]),str(v[4])])
	print s
	print e
	hotnum+=1

coldnum=1
for v in sorted(cold.values(),key=lambda i:-i[5]):
	s="\t".join([v[0],str(coldnum),str(v[1]),str(v[3]),str(v[4])])
	e="\t".join([v[0],str(coldnum),str(v[2]),str(v[3]),str(v[4])])
	print s
	print e
	coldnum+=1

	

