import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

from truncationobject import *



parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--hot', type=str, required=True, dest="hot", help="Truncations in hot conditions")
parser.add_argument("--cold", type=str, required=True, dest="cold", help="Truncations in cold conditions")
args = parser.parse_args()
keyset=set([])
hotl=TruncationReader.readall(args.hot)
coldl=TruncationReader.readall(args.cold)

for h in hotl:
	k=h.key
	keyset.add(k)

for c in coldl:
	k=c.key
	keyset.add(k)

counter=1
for k in keyset:
	print "{0}\t{1}".format(k,counter)
	counter+=1
