import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

from truncationobject import *


def print_firstemergence(truncations,prefix,basekeys):
     dict=collections.defaultdict(lambda:collections.defaultdict(lambda:90))
     for t in truncations:
          r=t.replicate
          r=r.lstrip("r")
          if t.generation < dict[r][t.key]:
               dict[r][t.key]=t.generation

     
     for replicate,tmp1 in dict.items():
          for key,firstgen in tmp1.items():
               pib=0
               if key in basekeys:
                    pib=1
               print "{0}\t{1}\t{2}\t{3}\t{4}".format(prefix,replicate,key,firstgen,pib)



parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--hot', type=str, required=True, dest="hot", help="Truncations in hot conditions")
parser.add_argument("--cold", type=str, required=False, dest="cold", default="", help="Truncations in cold conditions")
parser.add_argument("--base", type=str, required=True, dest="base", help="Truncations in base population")
args = parser.parse_args()

# levels: replicate - key - generations


hotl=TruncationReader.readall(args.hot)
base=TruncationReader.readall(args.base)

basekeys=set([])
for t in base:
     basekeys.add(t.key)

print_firstemergence(hotl,"hot",basekeys)


if args.cold!="":
     coldl=TruncationReader.readall(args.cold)
     print_firstemergence(coldl,"cold",basekeys)


