import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

from truncationobject import *

parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--hot', type=str, required=True, dest="hot", help="Truncations in hot conditions")


args = parser.parse_args()




hot=TruncationReader.readall(args.hot)

all=collections.defaultdict(lambda:0.0)
pot=collections.defaultdict(lambda:0.0)
repend=416

for t in hot:
    r=t.replicate
    g=int(t.generation)
    if g!=20:
        continue
    start=t.start
    end=t.end
    pf=float(t.popfreq)
    all[r]+=pf
    if(start>repend):
        pot[r]+=pf
print(all)
print(pot)
        
