import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

import truncations


def get_splice_support(tr_start,tr_end,readcol):
     count_left_presence=0
     count_left_absence=0
     count_right_presence=0
     count_right_absence=0
     
     trunc=(tr_start,tr_end)

     for sam in readcol.sams:
          hasplice=False
          for t in sam.get_truncations():
               if t==trunc:
                    hasplice=True
     
          if(hasplice):
               count_left_presence+=1
               count_right_presence+=1
          else:
               if sam.start() < tr_start and sam.end() > tr_start:
                    count_left_absence+=1
          
               if sam.start() < tr_end and sam.end() > tr_end:
                    count_right_absence+=1

     coverage=int(count_left_presence+count_right_presence+count_left_absence+count_right_absence)

     pres_fraction=0.0
     if coverage> 0.0:
          pres_fraction=float(count_left_presence+count_right_presence)/float(coverage)
     return (count_left_presence+count_right_presence, count_left_absence+count_right_absence, pres_fraction)
     


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")
parser.add_argument('--sam', type=argparse.FileType('r'), default=None,dest="sam", required=True, help="A sam file")
parser.add_argument("--sid", type=str, required=True, dest="sid", help="The replicate")

args = parser.parse_args()


s=truncations.PTruncSamEntry.load(args.sam)
i0p,i0a,i0f = get_splice_support(442+1,501-1,s)

i1p,i1a,i1f = get_splice_support(1168+1,1222-1,s)

i2p,i2a,i2f = get_splice_support(1947+1,2138-1,s)


print "{0}\t{1}\t{2}\t{3}\t{4}\t{5}\t{6}\t{7}\t{8}\t{9}".format(args.sid,i0p,i0a,i0f,i1p,i1a,i1f,i2p,i2a,i2f)
               
  