import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

import syncIO


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")

mincount=1
parser.add_argument('--sync', type=str, required=True, dest="sync", help="Data")
args = parser.parse_args()

sr=syncIO.SyncReaderMajMin(args.sync)

pidict=collections.defaultdict(lambda:0.0)
snpdict=collections.defaultdict(lambda:0)

for cr,pos,rc,counts in sr:
     i=1
     for ma,mi in counts:
          if(ma >=mincount and mi>=mincount):
               su=float(ma+mi)
               fa=float(ma)/su
               fi=float(mi)/su
               pi=1-fa**2-fi**2
               pidict[i]+=pi
               snpdict[i]+=1
          i+=1
     
for i in sorted(snpdict.keys()):
     pi=pidict[i]
     snp=snpdict[i]
     avpi=pi/2907.0
     print "{0}\t{1}\t{2}".format(i,snp,avpi)
     