import sys
import random
import argparse
import collections
import fileinput
import math
import re
import os
import inspect



 # realpath() will make your script run, even if you symlink it :)
cmd_folder = os.path.realpath(os.path.abspath(os.path.split(inspect.getfile( inspect.currentframe() ))[0]))
if cmd_folder not in sys.path:
     sys.path.insert(0, cmd_folder)

 # use this if you want to include modules from a subfolder
cmd_subfolder = os.path.realpath(os.path.abspath(os.path.join(os.path.split(inspect.getfile( inspect.currentframe() ))[0],"../Modules")))
if cmd_subfolder not in sys.path:
     sys.path.insert(0, cmd_subfolder)

import syncIO
from syncIO import SyncReaderMajMin




parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
miRNA: 21-23nt
piRNA: 23-28nt


Authors
-------
    Robert Kofler
""")
parser.add_argument('--sync', type=str, default=None,dest="sync", required=True, help="A sync file")
parser.add_argument("--min-count", type=int, required=True, dest="mincount",  help="min mapping quality")
args = parser.parse_args()
mc=args.mincount

for line in open(args.sync):
	chr,pos,tmp,mami=SyncReaderMajMin.parse_line(line)
	cma=0
	cmi=0
	for ma,mi in mami:
		cma+=ma
		cmi+=mi
	if cma>=mc and cmi>=mc:
		topr=[chr,pos,tmp[2],tmp[0],tmp[1]]
		for ma,mi in mami:
			topr.append(int(ma))
			topr.append(int(mi))
			
		print "\t".join([str(i) for i in topr])	
