#!/usr/bin/env python
import os
import sys
import re
import argparse
import random
import collections




def clustersForChr(toparse, threshold,binsize):
    ## toparse hash: position -> clusterreads
    
    toret=[] # list of start and end positions
    lhs=0  # last high score
    lhsp=-binsize # last high score position
    lastpos=sorted(toparse.keys())[-1] # get the last position
    
    while(lastpos!=lhsp):
        # for all piRNA clustes that could be found on the chromosome
        aktive=False
        runningscore=0  # actual score at the moment
        clusterstart=0
        for pos in range(lhsp+binsize,lastpos+binsize,binsize):
            localscore=toparse[pos]-threshold
            
            if(pos==lastpos):
                if(aktive):
                    toret.append((clusterstart,lhsp,lhs))
                lhsp=lastpos
                break

            if aktive:
                runningscore=runningscore+localscore
                if(runningscore>=lhs):
                    lhs=runningscore
                    lhsp=pos
                elif(runningscore>0):
                    pass
                else:
                    aktive=False
                    toret.append((clusterstart,lhsp,lhs))
                    break
                    
            else:
                if(localscore>0):
                    lhs=localscore
                    runningscore=localscore
                    lhsp=pos
                    clusterstart=pos
                    aktive=True
    return toret
    
    


parser = argparse.ArgumentParser(description="""           
Description
-----------
    This script simulates single-end reads from the population genome""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
Prerequisites
-------------
    python version 3+

Authors
-------
    Robert Kofler 
""")


parser.add_argument("--bin", type=str, required=True, dest="bin", default=None, help="binsize")
parser.add_argument("--threshold", type=float, required=True, dest="threshold", default=None, help="binsize")
parser.add_argument("--binsize", type=int, required=True, dest="binsize", default=None, help="binsize")

args = parser.parse_args()

binsize=args.binsize
threshold=args.threshold
"""
650399182	100	114
650396740	0	48
650396740	100	74
650396740	200	99

"""

ph=collections.defaultdict(lambda:collections.defaultdict(lambda:0))

for l in open(args.bin):
    a=l.rstrip("\n").split("\t")
    chrm,pos,count=a[0],int(a[1]),float(a[2])
    ph[chrm][pos]=count
    
for chrm,tmp in ph.items():
   
    clusters=clustersForChr(tmp,threshold,binsize)
    for c in clusters:
        print("{0}\t{1}\t{2}\t{3}".format(chrm,c[0],c[1]+binsize,c[2]))