#!/usr/bin/env python
import os
import sys
import re
import argparse
import random
import collections




def loadclusterinsertions(file):
    toret=collections.defaultdict(lambda: [])
    for l in open(file):
        a=l.rstrip("\n").split("\t")
        chrm,start,end,score=a[0],int(a[1]),int(a[2]),float(a[3])
        toret[chrm].append((start,end))
    return(toret)


            
    


parser = argparse.ArgumentParser(description="""           
Description
-----------
    This script simulates single-end reads from the population genome""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
Prerequisites
-------------
    python version 3+

Authors
-------
    Robert Kofler 
""")


parser.add_argument("--cluster", type=str, required=True, dest="cluster", default=None, help="binsize")
parser.add_argument("--teinsertions", type=str, required=True, dest="teinsertions", default=None, help="binsize")
args = parser.parse_args()

clusters=loadclusterinsertions(args.cluster)


for l in open(args.teinsertions):
    """
    5	60	3L	6204340	0.147
    5	60	3L	660714	0.094

    """
    l=l.rstrip("\n")
    a=l.split("\t")
    chrm,pos=a[2],int(a[3])    
    isclusterinsert=0
    clusterlist=clusters[chrm]
    for start,end in clusterlist:
        if pos>=start and pos<=end:
            isclusterinsert=1
    print l+"\t"+str(isclusterinsert)
        
    