#!/usr/bin/env python
import os
import sys
import inspect
import re
import argparse
import random
import math
import collections
import fileinput




parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")

def load_signature(file):
     toret={}
     for l in open(file):
          a=l.rstrip("\n").split("\t")
          """
          r1-12	RT1C	as	9	0.0133563813729
          r1-12	RT1C	as	10	0.652512606002
          """
          if a[2]=="as":
               continue
          pos=int(a[3])
          if pos !=10:
               continue
          fam=a[1]
          sig=float(a[4])
          toret[fam]=sig
     return toret
          
          
parser.add_argument('--input', type=str, default=None,dest="ip", required=True, help="A ping-pong signature file")
parser.add_argument("--rep", type=str, required=True, dest="rep",  help="replicate")
parser.add_argument("--gen", type=str, required=True, dest="gen",  help="generation")
parser.add_argument("--cond", type=str, required=True, dest="cond",  help="generation")
args = parser.parse_args()

sigs= load_signature(args.ip)




teprintlist=["1360","412","ACCORD","AF222049","AF418572","AF541951","BAGGINS","BLOOD","BS","BS3","BS4","Beagle","Beagle2","CIRC","DIVER2","DM06920","DM23420","DM33463","DM88","DMAURA","DMBARI1","DMBLPP","DMCOPIA","DMCR1A","DMDM11","DME010298","DME278684","DME487856","DME542581","DME9736","DMGYPF1A","DMHFL1","DMIFACA","DMIS176","DMIS297","DMLINEJA","DMMDG3","DMREPG","DMRER1DM","DMRER2DM","DMRTMGD1","DMTHB1","DMTN1731","DMTNFB","DMTOM1_LTR","DMTRDNA","DMU89994","DMW1DOC","DMZAM","DM_ROO","DOC2","DOC3","DOC4","DOC5","F","FB","FROGGER","FW2","FW3","G2","G3","G4_DM","G5A","G5_DM","G6_DM","G7","GTWIN","GYPSY10","GYPSY11","GYPSY12","GYPSY2","GYPSY3","GYPSY4","GYPSY5","GYPSY6","GYPSY7","GYPSY8","GYPSY9","HEL","HOPPER2","INE1","INVADER","INVADER2","INVADER3","INVADER4","INVADER5","INVADER6","IVK","JOCKEY2","JUAN","LOOPER1_DM","M14653","MARINER2","McCLINTOCK","OPUS","OSV","PPI251","Q","QBERT","QUASIMODO","R1-2","ROOA_LTR","ROVER","ROXELEMENT","RT1B","RT1C","S2","SPRINGER","STALKER","STALKER2","STALKER3","STALKER4","TABOR","TC1","TC1-2","TC3","TIRANT","TRANSIB1","TRANSIB2","TRANSIB3","TRANSIB4","Tinker"]

cond=args.cond
gen=args.gen
rep=args.rep

for fam in teprintlist:
     default=1
     sig=1.0/float(19)
     if(fam in sigs):
          sig=sigs[fam]
          default=0
          
     
     topr="{0}\t{1}\t{2}\t{3}\t{4}\t{5}".format(cond,rep,gen,fam,sig,default)
     print topr
 
