#!/usr/bin/env python
import os
import sys
import re
import argparse
import math
import collections

parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
""")
parser.add_argument("--rs", type=str, required=True, dest="rs", default=None, help="Readstat file" )
sortorder=("1360","17.6","1731","297","3S18","412","BS","BS3","BS4","Bari1","Bari2","Burdock","Circe","Cr1a","Dm88","Doc","Doc2-element","Doc3-element","Doc4-element","F-element","FB","Fw2","Fw3","G-element","G2","G3","G4","G5","G5A","G6","G7","GATE","HB","HMS-Beagle","HMS-Beagle2","HeT-A","Helena","I-element","INE-1","Idefix","Ivk","Juan","Mariner","Max-element","McClintock","NOF","Osvaldo","P-element","Porto1","Q-element","Quasimodo","R1-2","R1A1-element","R2-element","Rt1a","Rt1b","Rt1c","S-element","S2","Stalker","Stalker2","Stalker4","TAHRE","Tabor","Tc1","Tc1-2","Tc3","Tirant","Tom1","Transpac","X-element","ZAM","accord","accord2","aurora-element","baggins","blood","copia","diver","diver2","flea","frogger","gtwin","gypsy","gypsy10","gypsy11","gypsy12","gypsy2","gypsy3","gypsy4","gypsy5","gypsy6","gypsy7","gypsy8","gypsy9","hobo","hopper","hopper2","invader1","invader2","invader3","invader4","invader5","invader6","jockey","jockey2","looper1","mariner2","mdg1","mdg3","micropia","opus","pogo","roo","rooA","rover","springer","transib1","transib2","transib3","transib4")
args = parser.parse_args()

tec={}
totalmapped=0.0
for l in open(args.rs):
    a=l.rstrip("\n").split("\t")
    if(a[0]== "reads_mapped"):
        totalmapped=float(a[1])
    elif(a[0]=="te"):
        fam=a[1]
        count=int(a[2])
        tec[fam]=count

for key in sortorder:
    count=0
    if key in tec:
        count=tec[key]
    rpm=float(count)/totalmapped
    rpm=rpm*1000000.0
    print("{0}\t{1}\t{2}".format(key,count,rpm))
        
