#!/usr/bin/env python
import os
import sys
import re
import argparse
import random
import fastaIO




parser = argparse.ArgumentParser(description="""           
Description
-----------
    This script simulates single-end reads from the population genome""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
Prerequisites
-------------
    python version 3+

Authors
-------
    Robert Kofler 
""")

def estimate_microhomology(seq1,seq2):
    
    assert(len(seq1)==len(seq2))
    toret=[]
    """
    AAA 
    TAA
    
    AAA
     TAA
    """

    for i in range(0,len(seq1)):
        comparisions=0
        homo=0
        for k in range(0,len(seq1)-i):
            comparisions+=1
            if(seq1[k+i]==seq2[k]):
                homo+=1
        toret.append(float(homo)/float(comparisions))
    return toret
            
    
    


parser.add_argument("--pseq", type=str, required=True, dest="pseq", default=None, help="seqof the p")
parser.add_argument("--truncs", type=str, required=True, dest="truncs", default=None, help="the read length")
args = parser.parse_args()

fragsize=25

pseq=fastaIO.FastaReader.readAllTuples(args.pseq)
pseq=pseq[0][1]

truncset=set([])

for l in open(args.truncs):
    l=l.rstrip("\n").split("\t")
    start,end=l[2],l[3]
    truncset.add((start,end))

acttr=[0.0]*fragsize
acttrc=0.0
randtr=[0.0]*fragsize
randtrc=0.0

for start,end in truncset:
    start=int(start)
    end=int(start)
    p1s=start-fragsize-1
    p1e=start-1
    p2s=end
    p2e=end+fragsize
    if p1s<0: p1s=0
    
    frag1=pseq[p1s:p1e]
    frag2=pseq[p2s:p2e]
    if(len(frag1)!=len(frag2)):
        continue
    mihom=estimate_microhomology(frag1,frag2)
    for i,val in enumerate(mihom):
        acttr[i]+=val
    acttrc+=1.0

    
    

for i in range(0,1000):
    start=random.randint(20,2887)
    end=random.randint(20,2887)
    if(start>end):
        start,end=(end,start)
    p1s=start-fragsize-1
    p1e=start-1
    p2s=end
    p2e=end+fragsize
    if p1s<0: p1s=0
    
    frag1=pseq[p1s:p1e]
    frag2=pseq[p2s:p2e]
    final=frag1+"|"+frag2
    if(len(frag1)!=len(frag2)):
        continue
    mihom=estimate_microhomology(frag1,frag2)
    for i,val in enumerate(mihom):
        randtr[i]+=val
    randtrc+=1.0
    

topr=["real"]
for v in acttr:
    tmp=v/acttrc
    topr.append(str(tmp))

print("\t".join(topr))

topr=["rand"]
for v in randtr:
    tmp=v/randtrc
    topr.append(str(tmp))

print("\t".join(topr))
        
    



