#!/usr/bin/env python
import os
import sys
import re
import argparse
import random
import fastaIO




parser = argparse.ArgumentParser(description="""           
Description
-----------
    This script simulates single-end reads from the population genome""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
Prerequisites
-------------
    python version 3+

Authors
-------
    Robert Kofler 
""")


parser.add_argument("--pseq", type=str, required=True, dest="pseq", default=None, help="seqof the p")
parser.add_argument("--truncs", type=str, required=True, dest="truncs", default=None, help="the read length")
args = parser.parse_args()

sh=10

pseq=fastaIO.FastaReader.readAllTuples(args.pseq)
pseq=pseq[0][1]

truncset=set([])

for l in open(args.truncs):
    l=l.rstrip("\n").split("\t")
    start,end=l[2],l[3]
    truncset.add((start,end))

trunccount=len(truncset)

microh=[0]*2*sh
microc=0
randh=[0]*2*sh
randc=0

for start,end in truncset:
    start=int(start)
    end=int(end)
    p1s=start-sh-1
    p1e=start+sh-1
    p2s=end-sh
    p2e=end+sh
    if p1s<0: p1s=0
    
    frag1=pseq[p1s:p1e]
    frag2=pseq[p2s:p2e]
    if(len(frag1)!=len(frag2)):
        continue
    for i in range(0,len(frag1)):
        if(frag1[i]==frag2[i]):
            microh[i]+=1
    microc+=1
    
    #frag1=frag1[:sh]+"|"+frag1[sh:]
    #frag2=frag2[:sh]+"|"+frag2[sh:]

    
    

for i in range(0,10000):
    start=random.randint(sh,2907-sh)
    end=random.randint(sh,2907-sh)
    if(start>end):
        start,end=(end,start)
    p1s=start-sh-1
    p1e=start+sh-1
    p2s=end-sh
    p2e=end+sh
    if p1s<0: p1s=0
    
    frag1=pseq[p1s:p1e]
    frag2=pseq[p2s:p2e]
    if(len(frag1)!=len(frag2)):
        continue
    for i in range(0,len(frag1)):
        if(frag1[i]==frag2[i]):
            randh[i]+=1
    randc+=1
        
    

pos=-sh+0.5
for v in microh:
    topr=["real"]
    tmp=float(v)/float(microc)
    topr.append(str(tmp))
    topr.append(str(pos))
    pos+=1
    print("\t".join(topr))



pos=-sh+0.5
for v in randh:
    topr=["rand"]
    tmp=float(v)/float(randc)
    topr.append(str(tmp))
    topr.append(str(pos))
    pos+=1
    print("\t".join(topr))
    



