#!/usr/bin/env python
import os
import sys
import re
import argparse
import math
import collections




        
        


class TEentry:
    def __init__(self,sid,gen,chr,pos,popfreq,anno):
        self.sid=sid
        self.gen=gen
        self.chr=chr
        self.pos=pos
        self.popfreq=popfreq
        self.anno=anno
    
def load_te(file,minf,maxf):
    """
    1	10	X	6709950	0.072
    1	10	X	16577419	0.093
    1	10	X	18325999	0.069
    """
    tes=[]
    for l in open(file):
        a=l.rstrip("\n").split("\t")
        sid=a[0]
        gen=int(a[1])
        chr=a[2]
        pos=int(float(a[3]))
        popfreq=float(a[4])
        if popfreq < minf:
            continue
        if popfreq > maxf:
            continue
        anno=a[5]
        t=TEentry(sid,gen,chr,pos,popfreq,anno)
        tes.append(t)
    return tes


def print_sum(tes):
    trans={"inter":0,"intron":1,"exon":2,"3p":3,"5p":4,"cds":5}
    for g in [0,10,20,30,40,50,60]:
        c=[0,0,0,0,0,0]
        tmp=tes[g]
        for t in tmp:
            a=t.anno
            p=trans[a]
            c[p]+=1
        s=sum(c)
        c.append(s)    
        print str(g)+"\t"+"\t".join([str(i) for i in c])


def print_gen(teh):
    trans={"inter":0,"intron":1,"exon":2,"3p":3,"5p":4,"cds":5}
    for r in ["1","3","5"]:
        for g in [0,10,20,30,40,50,60]:
            c=[0,0,0,0,0,0]
            tmp=teh[r][g]
            for t in tmp:
                a=t.anno
                p=trans[a]
                c[p]+=1
            s=sum(c)
            c.append(s)
            print str(r)+"\t"+str(g)+"\t"+"\t".join([str(i) for i in c])


parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""
""")
parser.add_argument("--te", type=str, required=True, dest="te", default=None, help="annotation" )
parser.add_argument("--min", type=float, required=False, dest="minf", default=0.0, help="annotation" )
parser.add_argument("--max", type=float, required=False, dest="maxf", default=1.0, help="annotation" )
parser.add_argument("--mode", type=str, required=False, dest="mode", default="sum", help="modes supported sum, detail" )
args = parser.parse_args()

minfraction=args.minf
maxfraction=args.maxf

tes=load_te(args.te,args.minf,args.maxf)

teh=collections.defaultdict(lambda:collections.defaultdict(lambda:[]))
tehs=collections.defaultdict(lambda:[])
for t in tes:
    teh[t.sid][t.gen].append(t)
    tehs[t.gen].append(t)

if args.mode=="sum":
    print_sum(tehs)
elif args.mode=="detail":
    print_gen(teh)
else:
    raise Exception("invalid")
    


    
    
    

