import sys
import random
import argparse
import collections
import math
import re
import os

parser = argparse.ArgumentParser(description="""           
Description
-----------
Summary statistics
""",formatter_class=argparse.RawDescriptionHelpFormatter,
epilog="""

Authors
-------
    Robert Kofler
""")

def load_te_hash(file):
    toret={}
    for l in open(file):
        a=l.rstrip("\n").split("\t")
        fam=a[0]
        rpm=float(a[2])
        toret[fam]=rpm
    return toret


parser.add_argument('--rpm', type=str,action="append",required=True, dest="rpm", help="Data")
parser.add_argument('--gen', type=str,action="append",required=True, dest="gen", help="Data")
parser.add_argument('--condition', type=str, required=True, dest="cond", help="Condition hot/cold")
parser.add_argument('--replicate', type=str, required=True, dest="rep", help="Condition hot/cold")
args = parser.parse_args()

rep=args.rep
cond=args.cond
#print(args.rep,args.cond,args.rpm)

teabundance=[]
[teabundance.append(load_te_hash(i)) for i in args.rpm]

ref=teabundance[0]
for i,ta in enumerate(teabundance):
    gen=args.gen[i]
    for fam,rpm in ta.items():
        rpmref=ref[fam]
        enr=rpm/rpmref
        print "{0}\t{1}\t{2}\t{3}\t{4}\t{5}".format(cond,rep,gen,fam,rpm,enr)