



class Truncation:
    def __init__(self,replicate,generation,start,end,count,popfreq):
        self.replicate=replicate
        self.generation=generation
        self.start=start
        if start>end:
            raise Exception("Invalid truncation; start larger than end")
        self.end=end
        self.key="{0}-{1}".format(start,end)
        self.count=count
        self.popfreq=popfreq


class TruncationReader:
	"""
	#r1	0	547	2722	1	0.0121337581045
	#r1	0	696	2282	1	0.0121337581045
	#r1	0	973	1211	1	0.0121337581045
	#r1	10	192	2555	2	0.0378426344511
	"""
	def __init__(self,file):
		self.__filename=file
		self.__filehandle=open(file,"r")
	
	def __iter__(self):
		return self
	
	def next(self):
		line=""
		while(1):
			line=self.__filehandle.readline()
			if line=="":
				raise StopIteration
			line=line.rstrip('\n')
			if line.startswith("#"):
				continue
			if line != "":
				break
		a=line.split("\t")
		# self,replicate,generation,start,end,count,popfreq
		e=Truncation(a[0],int(a[1]),int(a[2]),int(a[3]),int(a[4]),float(a[5])) 
		return e
	
	@classmethod
	def readall(cls,file):
		entries=[]
		for e in TruncationReader(file):
			entries.append(e)
		return entries



class TruncationWriter:
	"""
	
	"""
	def __init__(self,file):
		self.__filename=file
		self.__filehandle=open(file,"w")
		
	def write(self,entry):
		# replicate,generation,start,end,count,popfreq)
		topr=[entry.replicate, entry.generation, entry.start, entry.end, entry.count, entry.popfreq]
		topr=[str(i) for i in topr]
		form="\t".join(topr)
		self.__filehandle.write(form+"\n")
		return 1
	
	def close(self):
		self.__filehandle.close()
	
	@classmethod
	def writeall(cls,file,truncentries):
		gw=TruncationWriter(file)
		for e in truncentries:
			gw.write(e)
		gw.close()
		return 1