%% Script for the in vitro fitting 
% This script does:   (i) loads the in vitro data; 
                    % (ii) fitting procedure that estimates the parameters: in vitro Kds, scaling factors, and normalization factors
%% (i) loads the in vitro data
    %% load in vivo iCLIP measurement data
       FID=fopen(['0308_vitro_peak_data.csv']); 
       D=textscan(FID,'%s %s %s %s %s %s %s %f %f %f %f %f %f %f %f %f %f','HeaderLines',1,'delimiter',',');
       Signal08= [D{[8:length(D)]}];

       FID=fopen(['0309_vitro_peak_data.csv']); 
       D=textscan(FID,'%s %s %s %s %s %s %s %f %f %f %f %f %f %f %f %f %f','HeaderLines',1,'delimiter',',');
       Signal09= [D{[8:length(D)]}];

       FID=fopen(['0311_vitro_peak_data.csv']); 
       D=textscan(FID,'%s %s %s %s %s %s %s %f %f %f %f %f %f %f %f %f %f','HeaderLines',1,'delimiter',',');
       Signal11= [D{[8:length(D)]}];

       FID=fopen(['0312_vitro_peak_data.csv']); 
       D=textscan(FID,'%s %s %s %s %s %s %s %f %f %f %f %f %f %f %f %f %f','HeaderLines',1,'delimiter',',');
       Signal12= [D{[8:length(D)]}];   
    %% data process:
    % add a small value to deal with the zero counts
        Signal08=Signal08+1; 
        Signal09=Signal09+1;
        Signal11=Signal11+1;
        Signal12=Signal12+1;
    %% specify protein and mRNA dose used in the in vitro experiment
    % total protein dose (U0) from in vitro experiment (uM)
        a08 = [30 50 150 250 450 750 3000 5000 15000 25000]./1000;
        a09 = [30 50 150 250 450 750 1500 3000 5000 15000]./1000; 
        a11 = [30 50 150 250 450 750 1500 3000 5000 15000]./1000; 
        a12 = [30 50 150 250 450 750 1500 3000 5000 15000]./1000; 
    % select the higher 8 doses and corresponding signals
        Dose1=[3:10]; 
        a08=a08(Dose1);
        a11=a11(Dose1);
        a12=a12(Dose1);
        Dose2=[3:4 6:10];
        a09=a09(Dose2);
        Signal08=Signal08(:,Dose1);
        Signal09=Signal09(:,Dose2);
        Signal11=Signal11(:,Dose1);
        Signal12=Signal12(:,Dose1);
        [n,c]=size(Signal08); 
    % total mRNA level (uM)
        b = 0.2/1000;
%% (ii) fitting procedure that estimates the in vitro Kds

    % parameter range: take logarithm of the parameter
     % lower boundary of in vitro Kd: 0.1 uM 
        lp=log(0.1).*ones(n,1);  
     % upper boundary of in vitro Kd: 1000 uM
        up=log(1000).*ones(n,1);

    % minimize the objective function from 100 multi-start optimization
for g=1:100

    % specify starting parameters: latinhypercube sampled from the parameter range
     p0=lhsdesign(n,1);
     p0 = lp + p0 .* (up-lp);
 
     % specify the inputs for matlab algorithm lsqnonlin
        minime = @(beta) FitInvitroAll4Replicates(beta,b,n,a08,a09,a11,a12,Signal08,Signal09,Signal11,Signal12);
        options=optimset('MaxIter',100000,'MaxFunEvals',100000,'Algorithm','trust-region-reflective','TolFun',1e-3);
 
     % minimize the objective function and assign the best fit values
     [p,chi2] = lsqnonlin(minime,p0,lp,up,options); 
         if g==1
             chi2r=chi2;
             pr=p;
         else
             if chi2<=chi2r;
                 pr=p;
                 chi2r=chi2;
             end
         end  
end

%% derive the best fit scaling factors and normalization factors if interested
[res, SFfit, Nfit] = FitInvitroAll4Replicates(pr,b,n,a08,a09,a11,a12,Signal08,Signal09,Signal11,Signal12);

save Fit2Invitro.mat