function [res, SFfit, Nfit] = FitInvitroAll4Replicates(beta,b,n,a08,a09,a11,a12,Signal08,Signal09,Signal11,Signal12)
    %% assign values to Kd
    LKd=beta(1:n,1);
    
    %% assign the levels of binding complex at different doses to the matrix: C8, C9, C11 and C12
       for ui = 1:length(a08)
            a1=a08(ui);
            [x] = binding(a1,LKd);
            C8(:,ui)=x;
       end
               
       for ui = 1:length(a09)
            a1=a09(ui);
            [x] = binding(a1,LKd);
            C9(:,ui)=x;
       end
       
       for ui = 1:length(a11)
            a1=a11(ui);
            [x] = binding(a1,LKd);
            C11(:,ui)=x;
       end
               
       for ui = 1:length(a12)
            a1=a12(ui);
            [x] = binding(a1,LKd);
            C12(:,ui)=x;
       end
              
       %% objective function: the equivalent term for -2log(Likelihood) for optimization.        
       % see Supplemental_Material: Strategies for parameter estimation      
        LC=[log(C8) log(C9) log(C11) log(C12)];
        LY=[log(Signal08) log(Signal09) log(Signal11) log(Signal12)];
        LSF=sum(LY-LC,2)/(length(a08)+length(a09)+length(a11)+length(a12)); % sum(LN)=0;       
        LN=(sum(LY-repmat(LSF,1,(length(a08)+length(a09)+length(a11)+length(a12)))-LC,1))/n;
        
        res=[];
        for ui = [1:(length(a08)+length(a09)+length(a11)+length(a12))]
             res = [res; LY(:,ui)-LSF-LN(ui)-LC(:,ui)];
        end 
       
        % get the best fit scaling factor
        SFfit=exp(LSF);
        % get the best fit normalization factor
        Nfit=exp(LN);

% subfunction to calculate the equilibrium concentration of binding complex
% at a given protein concentration a1 and affinities Lkd
	function [RNAU2] = binding(a1,LKd)
          RNAU2 = b*a1./(exp(LKd)+a1); 
    end
end