function [res RNAU2] = FitInvivoAll3Replicate(beta,pstandard,Invivo,bintron,SFfit)

%% assign values to Kd, u protein, and each intron
Kd = pstandard;
u=beta(1);
bvari=zeros(size(Kd));
for i=1:length(Kd)
bvari(i)=beta(bintron(i)+1);
end

res=[];
%% in vivo signal
Fit=[Invivo(:,1);Invivo(:,2);Invivo(:,3)];
%% calculate the [RNA:U2AF65] complex level from the iCLIP signal model
RNAU2 = [SFfit.*bvari.*u./(Kd+u);SFfit.*bvari.*u./(Kd+u);SFfit.*bvari.*u./(Kd+u)];
%% objective function: the equivalent term for -2log(Likelihood) for optimization.
res = [res; log(RNAU2)-log(Fit)];        
end