## Supplementary code 1, Boot et al.

## set number of cores to be used
cores = 1

# load mSigTools and mSigAct
source("src/mSigTools.v0.8.R")
source("src/mSigAct.v0.9.R")

# load signatures
cosmic.sigs <- 
  get.signatures(
    signature.file='COSMIC_plus_cisplatin.tsv',
    exome.op=.h19.96.sureselect.v6.op)
cosmic.wgs <- cosmic.sigs$genome


## analyse the Fujimoto et al. HCC genomes
liverSigs <- 
  c(paste('Signature', c(1,4:6,12,16,17, 'AA',23,24), sep = '.'),
    "Cisplatin")
liverSigs <- cosmic.wgs[, liverSigs]

fujimoto<-read.96.duke.nus.format("input catalogs/Fujimoto et al catalog.tsv")

fujimoto_analysis <- process.one.group(fujimoto, liverSigs,
                     target.sig.name = "Cisplatin",
                     path.root = "mSigAct_Figures",
                     obj.fun = obj.fun.nbinom.maxlh,
                     nbinom.size=10, ## = dispersion parameter
                     mc.cores=cores) ## = number of cores to use

# explore results Fujimoto HCCs
pval<-fujimoto_analysis$pval
apval<-p.adjust(pval,"bonferroni")
exposure<-fujimoto_analysis$exposure
df<-t(rbind(pval,apval,exposure))
df<-df[order(df[,1],decreasing = F),]


## analyse the Kan et al. HCC genomes
Kan<-read.96.duke.nus.format("input catalogs/Kan et al catalog.tsv")

Kan_analysis <-  process.one.group(Kan, liverSigs,
                        target.sig.name = "Cisplatin",
                        path.root = "mSigAct_Figures/",
                        obj.fun = obj.fun.nbinom.maxlh,
                        nbinom.size=10, ## = dispersion parameter
                        mc.cores=cores) ## = number of cores to use

# explore results Kan HCCs
pval<-Kan_analysis$pval
apval<-p.adjust(pval,"bonferroni")
exposure<-Kan_analysis$exposure
df<-t(rbind(pval,apval,exposure))
df<-df[order(df[,1],decreasing = F),]


## combine Fujimoto and Kan HCCs, and perform multiple testing correction for entire HCC cohort
# Fujimoto
pval<-fujimoto_analysis$pval
apval<-p.adjust(pval,"bonferroni")
exposure<-fujimoto_analysis$exposure
df<-t(rbind(pval,apval,exposure))
df1<-df[order(df[,1],decreasing = F),]

# Kan et al
pval<-Kan_analysis$pval
apval<-p.adjust(pval,"bonferroni")
exposure<-Kan_analysis$exposure
df<-t(rbind(pval,apval,exposure))
df2<-df[order(df[,1],decreasing = F),]

df<-t(as.data.frame(cbind(t(df1),t(df2))))
df[,2]<-p.adjust(df[,1],"bonferroni")
df<-df[order(df[,1],decreasing = F),]



## analyse the ESAD genomes
## Esophagus not in COSMIC dataset, so instead use the combined signatures from stomach and oral carcinomas
sigs <- c(paste('Signature', c(1,2,5,7,13,15,17,18,20,21,26,28,29), sep = '.'),"Cisplatin")
sigs <- cosmic.wgs[, sigs]

ESAD<-read.96.duke.nus.format("input catalogs/ESAD catalog.txt")

ESAD_analysis <- process.one.group(ESAD, sigs,
                       target.sig.name = "Cisplatin",
                       path.root = "mSigAct_Figures",
                       obj.fun = obj.fun.nbinom.maxlh,
                       nbinom.size=10, ## = dispersion parameter
                       mc.cores=cores) ## = number of cores to use

# explore results
pval<-ESAD_analysis$pval
apval<-p.adjust(pval,"bonferroni")
exposure<-ESAD_analysis$exposure
df<-t(rbind(pval,apval,exposure))
df<-df[order(df[,1],decreasing = F),]
