#include "SeqFrag.h"

#include <iostream>

void SeqFrag::addScrambledEnds(size_t left_len, size_t right_len) {

  std::vector<std::string> TCGA = {"T","C","G","A"};
  
  std::string left, right;
  for (size_t i = 0; i < left_len; ++i) 
    left += TCGA[rand() % 4];
  for (size_t i = 0; i < right_len; ++i) 
    right += TCGA[rand() % 4];
  
  left_scramble = left;
  right_scramble = right;

  m_seq = left + m_seq + right;

}

void SeqFrag::spikeMicrobe() {

const char* PSUEDO = "CAAAAAGACATTTTTTTTGGGATATTAAGATTTCCTAGGATAGAAATCAAATTATTAGATAATTTTTGTATATATTTTAA"
"ATATGTCTTAAAAAAATGTCTTTTTGTCTAAATATATTAAGCTTTTCATTTTTACATCGACAAATTTAGATATTTTTAGA"
"CATTTTGGGTATTTTTTTAGACATTTTTAAAATATTTTAGACAGAATTGTATTATGATCCTATTTTTAGACCTAAATATA"
"TGCAAAATTATCATATCGTCGTGGAGTGTTACCAAGTAATTCACTATATTGATACAAATCATTACCTCTATAATCTGGTT"
"TAAAGGGAAGTTCTTTAATTGGTTCTTTCTTATCCTCTTTTTTATCCTCATCATTACCTTTATGAGCATTGTTTCTACAC"
"ATGTATTTGACTAGAAAGAAAAATAATATAAACAATATTATAAGTACTATAAAAGTAAATATACATATTTTGATCATCAT"
"TTTGTTACCAATTTCATTACCAACTTCCTTGCCTATAACGCTGAACGCATTATATGCAATGGGATCCATCGCGAAAGGAT"
"TTTCCATTACTATCTATTATATCATTACATAATTGTTTATTGTTCTATAAATAATAAACAAATATACACTATTAGATAGT"
"TTTTACCATCCAAATTCTTTCATAAACTCATTAATATCTTCTATTGACTTGCATTCTTCTAGTTCAATCCAATATATTGG"
"TGTTTCTGGATCAATTTCTTCGTTTTCCTCTTCTTGTTTATCAAGATATTCTATTAGATCATTCTCTGCTCTGTTTCTCA"
"ATGATTCAAGTTTTTTCTGTTCTTTTTTCAAGAGTTTTTTACTCACACTAAATTTACCATACATTAATATATAATACTAT"
"AAAATACTATATATTAATTATCTTTATATCATTTTATATTAATTTATATTATTTTGATAAATTTTCCACGTATTTATAAT"
"AATCATTAAATGTTCCTGATCTTACCGATTGATATTTGTTACGAACAGATTGTTGTTGTTCTTCAGTAGTTTTATCCCAT"
"TCATCAACCATAATATTTCTAAAATTGGTTTTTGGTGCGACTATTTCTAATTTTTTTTTGTATGAATTAGCTTCTCTTTT"
"GAATTTAGCAATATCACTCAACATAAGATTTTTAAGATCCTTTTCTATGAGTAGTTGTTCTTCCAATTCTGTAACGGTTA"
"ATATTTTTTCCCTAGTCGTTATAAAAGCTTTTTCAAGAGCCATCGCTAATTGATCATATGATACAAAATTTTCATCATCT"
"ATATTTTCTAATACTTCTTCAGCATTTCTTTTAATTTTTTTAGCTTTACTTGCCATTATATATACTATATTTACATATAA"
"TTATTTATCATTATCATTAATAAAAAAATCAACCATTTCTTTTAGATTATTCTTTTTTTTTAGAGTAGATATTAAGTTAT"
"AATTTTGTATAATTTAGGTTGTTTATGGGATTTTTTAGGTTTATTTTCTGTAACAGACATGAACATTGATCCACCATGTT"
"GATCATTATCATCATCAAGAAGATCATCAACATTATCATTATAATTATCGGCCTCATTTAATTCATTTTCATCAGTATTA"
"TAATTTCCAGATGATTGATTATCATCATCACTTTCATTATCACTTTCATCACTGACGTCAAAGATAACTTCTTTTTTTGA"
"TTTAACAATCTTTGGTGTTTTTTTAACCATTTTTTTGCCTCTTTTTGACTTAGATTTGACTGGTTCTATCTCAGTTTCTG"
"ATTCAACTTCCTCATCGGATTCATTATCAGATTCATTATCAGATTCTTCTGATTCACTTGATTCATCTCTAGATTTTGAT"
"ATTTTTTTGGTTGTTCTATTCAATTCCTCTTTCATCATTTTTCTGGTTTTATAAAAAATTGGTTTACTGATTCCAGCTTT"
"CTTACAAGCTTGAACCACTGTCAAACCACCTTTCAAATAATATGATTCGGCTTTTTCATATAATATTTTATTTCGTCGGT"
"ATCTTAGGTTTTCTAGAACAGACATGTCCTTTATTATACCTAAATAATATTATTTTTATACCAAAACAGATCCTTTATCA"
"TATACACATAATTCGGATCCAATCCGATTTTTTACTTTGATAAAAAGGCGAAAAATAATCAAAGTAAAAAGTAAGAAATA"
"TTAAATATATGCATAATATAATATTATAATGTCGCATAATTGTCAAAATAGTAATGAACCTGATACAGTGTATTATGATA"
"TAGTTATCCCATATAATCCCAATGATTCTGGTTTAAGCCCAGCAACATTCCAAGCACAGTTAACACAACCATTGCTTTAT"
"AATCCTGACAAATATTACCTGAGTGTAGTGAGGTTCAGTATTCCGACCCAATATGTACCCTTAATGATACCTGAAATACA"
"ACCTTTTCCAAATACTAATGTTAATAATACCATATATTCAGTTACACTAGAGTATAATGGTGTATTTTCATCTCAAACAT"
"TTGTACAATATGATGTATCTTTAACTAATCCTAATGATACTCCTCCACCTCCTCCAACAATCAATAATAGGACAGTAGAA"
"CCAACAGCCTATTATTATGTTTATAATTTCTCGCCATTTTTACAAATGATCAACAAAGCACTTTCTGATGCTTTTACTGA"
"AATTACTATGCCAGTTGGCGCAGTTGCTCCATATTTTGTATACAGTCCGGTCACACAAAGGATTAGTTTAGTAGCACAGA"
"GGCAATTTTATGATAGAAATTTAGCGCAACCTATTAGAATATATTGTAATGAGGCATTATTCCCATTTTTAGATGGAATA"
"CCATTTGGAGGACTTGATTTTAATAGTGTTGATGGGCGTGATATATTATTCAATGTGGAAAATTTAGGTAATAATTTGGT"
"TCAAAATCAGCTAACGGCTCCAGCATATCCTCCTGAATTTATCCAAATGGAACAAGAATATGCTACACTTTCTAACTGGA"
"ATGCTATAAAAACTATCCAATTAGTATCCAATCTTTTACCTATTAATAGAGAATTTATCCCATCATTTAGAAATACTAAT"
"GTAGGTGTAGTTAATTCACAAGGTATTTTAGCAGACTTTGTACCATTGGTAACACTTGGGCCAGAATCTAGAACCAGTAT"
"AGATTATGTTGCAAATGGTCCTTGGAGATTAATAGATATGTTTGGAGGAGTACCTATAACAATGGTTGATTTATCAGTAT"
"ATTGGACAGATCAAATAGGAAGACGATTTGTGTTAGATGTACCCAGAGGTAGAATAGCAACCTGTAAATTAATATTCATT"
"AAGAAGGATCTGGCAGGTCACACTCTATCTCGGAAATAATAGATAGTTAATGTTTCATCAAAATATAATATAATAATATA"
"GTATATTAAGAATATGTCAAATAGTGCTGTACCTTTAAATGTTGTAGCAATTCAAGAACCCCGTCTTGAACTTAATAATG"
"AAAGAACTTGGGTAGTGGTTAAAGGTGGTCAACAAGTCACCTATTATCCTTTCCCTTCAACTTCTTTCAGCTCTAATCAA"
"TTTAATTTCATTTGTAATCCTCCTTCAGCACAAACTGTATTGGATCGATTAGCATTCATTCAAGTTCCTTATGATATCAC"
"TTTCAATGTTAATCCTGCTCATGCTGGTGTAACTGACAATCTTTTACAACCTGGTCGTGATGCTTTCCGTGCTTTCCCTA"
"TTAGTTCTATTACTAATACTTTAACTGCAACCATTAATGGTTTCCCTGTGAATATTGAATTAGGACAAATTATTCACGCT"
"CTTAGCAGATATCATACTCCTCTTAAACTTAAAAATGGATGGATGTCTATGCAACCTTCTTTTGAAGATAATTATCAATC"
"ATATCGTGATGCTGATGCCACTAATAACAATCCTTTAGGTGATTTTACAAGCGCATCTGGTCTTTCTGAGCTTCCAAGAG"
"GATCATATTCCATGAATGTTGTGTCAAATACTCCTACTACTGCTAGAATTACTGGTGTACTTTATGAACAAGTATTCCTT"
"CCTCCATTTATTTGGGATGAACATCAAGCTGGTGGTCTTGCAAATCTAACCAGTTTAACCTTCAATTGGGTACTAAATAA"
"TAATCTTGCTAGAATATGGTCTCATTCAGATATTACTAATGATGTTTCTGGAAACAGTACTATTGGTTCAATGAATGTCA"
"GCTTCCAACAACCCTCAATGTATCTTGGATTTGTTACTCCTCGATTAAATATTCCTATTCCTCCCAGAATAACTTATCCT"
"TATTTCAAACTTTCAAGATACACTACACAATTCCAAAATACTCTTGCTCCCAATGCAACCAGTACTTACAAATCTAATAT"
"TGTTCAACTTGATTCTATTCCAAGGAAACTTTATGTATTCATGAAACAATCTGATTCAGTGATTTATCAAAATCTCAATA"
"ATCAAATTACCACTCCTGATGTATTCCTACAAATCAATTCTCTCAATTTAACTTGGAACAATCAACAGGGTGTTCTTTCT"
"GGAGCATCTGCACAAAATTTATATGACTTCAGTGTTCAAAATGGTTACAACAAGACTTGGACTGAATTTAATGGTCTTAC"
"ACAACAATTATCAGGAGTCTCTGGATCACCTACCAAAGTAATTGGTCTTGAAGGAGGAATAGTTTGTCTCGAATTAGGTA"
"AAGATGTAGGATTACGTGACGATGAAGCTGAAGGTGTGCTTGGTAATTTCAATTTACAAGTACAAATGACTTGCACTAAT"
"ACTAATCAATATCTCACAATCGTACCTGATATGTATATTATTGCAGTATATGATGGTACTCTTGTTATCTCTAATACTAG"
"TGCTATGGCATCAATTGGTGTTGCCTCTAAAGAAGAAGTATTAAATGCTCCCATTAATCATAGCATGTCATATCACGAAT"
"TACAAACTGTATATGGAGGAGATTTCTTTAGCACATTTAAGAATTTCCTTGGAAAAGCCGCTAATGTAGCCGGAAAGGTA"
"AATAATTTTCTCAAAGATTCAAAAGTAGCTAGTTCTGTGCTAGGAGCTATTCCTCATCCTTATGCTCAAGTTCCTGGACA"
"AATTTTAAGGAATATTGGTTATGGTGAAGGTGGAGTATCTGCTGGTGGTGTTGTTGCTGGATCTGGAAGAAGAAAGAAAG"
"GTGGAGTATTAGTAGGAGGCAGTGAATGTGAAGGTGGAAGATATATGTCCAAAGCTGAATTAAAGAAAGCTTTACGAATG"
"TAAACACTATTAAATATAATATTGGTTAATAATATATTTAATATGAACATCAGAATAAAAGATTATTTCGATCATCCTTT"
"TATTAAATTTGATCCAAGGGAAGTTAAACCAATTGAATCATATACTCAAGAACAAATCAGTAATATCAAATTATTATCTG"
"TTACTTCTGATCCTACACAAATGGCAAGACCTTTTGGATCTGCTACATATCGTATTCAAAAATATCCTGGAGATTTAGAT"
"TTACAAGAGGAATTCATTGATTGTTGTTCCATAAATGAGGTTGTTAAAACATTTGCTAAGAGATTACAAAAAATAGTCAC"
"CAATATCAAAAAAAATAAGTTACATTATTTTTCAGAGGTAAAAGCTGGGATTGATATTAGATACGATATTGATATTGGCA"
"TAATAACTAGTGGAGTGTATATTCCCAGTTTTAATTTGATCCAAAAAATACAATCAATGTATCGAAAAGGATTATTAGAT"
"GATGAAGAATACAATACTTTATCTACAGCATTATCAAAACCTAATTTAGATGGTGATGTATATGACGTCGTTCATCATAT"
"TTTGAGAGAACGTAAAATATTGAGATGGTCACAAGAAGAGGTGTTATTGGGTACAAAAAGTCTTCCTTTAGGGAAAAAAA"
"TAAAGCTATCTGAAGCATTGAAGGCAAAATCACATGTAAAAATAGACATGATATCACTCATTAATAATCAGTTTGTTGAG"
"GTAACTAATTTCTATATTTTGATTTATGTCGATTTGAAGAAAAATACTTTGGAGACTGTTAATTTTAATTTCGATTATCT"
"TGATAACAACATACTTACCAAACAATATGATATGCAAATCAAAGAGGAAGTACAAAAATTGTATTACTCTGATATGTATT"
"ACAGTGCTTTCAAGATGGTCAAAAGAATGTGGGCATATTCAAGAGCTTTTAGAAATATGGAAGATGTCAATATATTATTA"
"CCTATTGTAAGTGGAAATATATCATTATTGTATCAGATTGTGAGTGAATTATCCACTATTGTGAGACTTTATGAAGTCAG"
"TAAATCAACTCCCGAAACAACAATAGATAAAAGATTAGATTCATTAGCCTATAAATTAGCTGATGTAACAGAAATAGATA"
"AAGAATCATTGATACATATCACAGATATAATTGATAGTTTGAAGAATTATAAAGGAATCAACAAAGCAATCCAAATAAAT"
"CAGTTTGTAATTAAACCATTGAAAAGATATATCAATGCTTTAACTATAGATGAATTGGAAGAAATAGGTTTTAATCCTCC"
"TCCTCCTAGATTTTTACCATATCCTTTGAAATATGCTCCTATTGTTAGATATCCTTTTGAGGATGTTGAAAACCCTTTGA"
"AGCAATACTAGAAGTGTTTATTTGTAAAAAAGCCAAAAAACAAATTAAAACAGATCAAAAGACTATTTGTCTAAAATATT"
"TTAAAAATGTCTAAAAAATGTCTAAATTTGTCGATGTAAAAATGAAAAGCTTCATATATTTAGACAAAAAGACATTTTTT"
"AGACATTTTTAAGATATATACAAAAATTATCTAATATTTTGATTTCTATCCTGGAAAATCTTAATATCCCAAAAAAAATG"
"TCTTTTTGTCTAAATTATTAAGCTTTTCATTTTTTACGCCGATATTTTTGACATTTTAGACAAATAATCATCAAAATAAT"
"ATGTGATCAATATGCTAATTTATAATATTTCTTTCTAAGCTTTCTATATTTTGCCTTTAAATGCTCATATTTATTCTCTA"
"ATTTATCCATTGCTTCATTGTGTTTCTTTGATTTCTTGTGATTAGAAGAATTACTTTTGGCATAAACTGCTCCACAAATA"
"GTACATTTCACTTTTTCCTTGTAATATTCCCTTTGTTTTTCCTTATTTGCTTCATAATATTTTTTATGATACTCATTTTT"
"TGATATGTCCATTATATTATAATATATTATTTTATATTAATATAATATTATTTTATATTATTTAGTATTATAGAGTAAAT"
"AATATAAAAAATAATTTACTCTATTAAAATGATGAAACAATAATATAGCTAATCTACCTCAATATCTGCTAGTATATCTA"
"TTTTTTTAATACCCTTCCAGAACCTAAAAGTGGATCTACCTTCCACTAATTTTAGTTCATCGCGGAGTATATCATTGAAT"
"CTGTTTAATGATATATCCTTAAATTCTTTGTGTGAATTTTTAAATTTTTTCATATCAGACACTGGTACTTTATCATTATC"
"TTTACCAGTGATTTCATAGTGCTCTTTAATGGTTTCAATAACAATATCATTTTGTTTTGTTTCAGCAGTCCATTTTTCTT"
"TGACTTCAGGATCAAATTCAGGCATACCATTTTTCAAATAATCTTGGTATGCATCAAGGAAAAGATGTATAAATCCTTTC"
"ATGAAATCTTTGGTCTCAAATTTTGATTCAATATTATTATCTTTGAGTTTGTAATAAGGTTTTTTATCGACATCTTCTTC"
"ATCAACAAAAACATAAGGAAATTCATTATATACTAATCTATTCATTACAGCTTGATCAAAAGGTTCAATATTAGGAACAT"
"CATTGAACATACAAAAAACAGTAAAATTAGGTTTGAAACTTTCTTCTGATTCTTGATGTTCTCTACCTACAATATTATCT"
"CCACCAGATGCAAGTCTTTTTATCATAATACCATCAAGAACAGAACCTTTCATTGGCATTTCATTTGACATTAATATTCT"
"AGTATGTGCAAGTTTATATGCCCATCTAAATTTTGCTGCTTCATCTCTTGAGTCATTCTTTTGATATAATAAATTTGCAC"
"CATTAAAATCACCAATATAACCTCCAAAACAATATTGTAACATCATAATTAAATATGATTTGCCAGCATTTGATCTCCCA"
"GGACAAAAATACATTTTTTTGAGTTTAATATCGCCAGCTAATGCACAAGCTAATGCTGTTATCATAGGTTTTGGATTATC"
"AAACAATTTCTTGAATGATAATCGATATGCTTTTTTGACCAAATCTTTGTCATATTTAGGGAATTTGTACGGCACACCAC"
"ATTTGAAAACTATTTTTGGATCAAATCCCTCAGTAAATGTTCCAGTCTTGAAATTATATATACCATCTTTAAATAAAAGA"
"TATCCTAATGACGATTTTGCAGTTCTTTTTAACCAATTATTATCCTCTGATACGTCTTTAACAAAACCTACAACCTTTTC"
"TCTTAATGTATGATCTGTACCATAATTTTTGGTTTTATGAACACCATTTTTATCAGTGGAAATAATAACATTGAGATACA"
"TTTGATGTTTTCTCAAATAGCGGAAAAGTATATGATTATTATCATCAAACATACCAGTATTTTCATCAAATATGTATAAC"
"TTTTTGTTACAGAATTTGAATTTTTCTGCTCCTTCTAATTCGAACAATTTTTCCTGACAATCACAATCACTGCTAACATA"
"AATACTATGATCTGGTACTTCAAAATCCAATTCATAGTTCATTGGTTTTTCTTCTAGATTAATCTTGTATTCTGTCTTAT"
"CATAGACATATTTTTCACAACCTTTCAATAAAACCTTAATATCCTCATCAAAGGAGTTAATCAACATACCATCAAAGCAT"
"AATGTACTCACTTTAATTTTTTTGCTAGTGAAATAATCATACATTGCCATTAAACACTTATGTTCTAATCGTTGTGCTAA"
"TATGGATAATACTACTGCTAATTTATTCTTACAATCATTATTATCCTTGATTTTCTCATAAAGACTTGTTTCTTTTTTAG"
"CTACTTTTTCAGCTATGTATTCTGCTTCTTCCTTAAATTTTGTGAGGAATTTTAATTTTTTGGTTGGTGTGTAGCTTTCA"
"CCATTATCATTAGTCAATTTATATGAACCAAGATAACATAATTTCAAGATCAGTTCTTTTGCCTTGTCTCTTGATATTTT"
"ATGGAAACTACTTATGTCTTCGAGTATCTTTTCTCTTCTATTGACATAATCAACTAAATATGGACACAATATGTCTTTTT"
"TTTTACAATATTGTGTAATCAATGTAGGATGTGAGTTTTTCATATCAATATCAGTATTAATTCCATTATTGATAAACCCT"
"CTAATACTCTTTTTGAAGGACTGAAGACTTTGTCCCTTCTCAGCATATACCCTACCAGTATCTTCTAATTTATCTGAATA"
"GTAATATTTCACCTTGACATATCCTATTTCATCTCCCTCTTCACGTTTTGTCTTGAACACTTTCTTGTAGTATGCACTTA"
"ATTGTCTCTGAATGTCTTCATCTAAATCTTCTGCTGATAACAATCTCTTCAAGTTTTTCATACTAATTGTTTCTGTCAGT"
"TTAATCACTGGCTTAACCACTTTCTTTTCAATTTTCTTAGTCACTTTCTTCTGTGTCTTACTCATTGTTTACTAGTATAT"
"ATGGTACTAGATATATTATTTTTATATCATTTTATATTATTATATAGTGAAAAAATATTCAATATTATTTCTATAGTTTG"
"AGCGTAATCTTTCGGCCTTACAATCCAACTTATACCCCCTTTTCTACGCTGTCTCAAAAATTTTGTGATGCGAATATATC"
"CGTATCATAAAATTGTCACATGCTCGTTAATGAGCATGTCATGTAAAAATGTCATCAGCTGATTAATAAGCCGCTGAAAA"
"ATACCAATATAATGGGAACTGAACAGCCGAAACTTCGGAAATATGACTGATATTTCCGAACCCTCTCCCTGTTCAGTTCC"
"TACTACAAATCAACTATATCACGTCCTTATCCATATATCATCATACTCTTTCTTATGACCAAATACCATCATATACACAT"
"AATTAAACATACTTATTATATTTGACACTAAATACTCAATCGGATTCATCTTCTTCATCTTCACTAACTAACACTTGATT"
"TTTTTTTACAAAGAATGTCGGATATTCATTCTCTAAATATTTGTATTGTTTTTCGGTGATATTACTTATTTTCTTTAATT"
"CTGACATTTGGTTTTGTAAATCAAGCATTTGTTTGTACATCTCATTCATATTATGTAATTCATAGATTTTTCTCATATAT"
"ATTTGTGTTTGTGATTCATTTTCTTTTTTCAGTTTCTCATTTTCTTTACTGACCTCATTTAATTCCCTTTTCAAATCATT"
"ATTTTCTGATTTAATCTCATTCAATTGTCTATGAAACATAATATTATTATCATTCATACTCGTTTGAAGTGATACTCTTA"
"GATCATTTTTGTTCTTATTGGTTTGATCAATCTCTTGATACAATGTATTAATACAAGATTGTAATTTTTGTTTACAATCT"
"TCGGGTAGCTTTACCAATATTTGTGAGATAATATTATTGATTTCCTCTTTATTTGACATCATATTGATAAGGTTATATTT"
"TATATTATTTTTTCAATCAACGGAATATCTCGTAAATGGTACAAACATTCGGCCTTATAAAAATAATATTATGTAATAAT"
"ATTACAATGGCTAAATTATATAAACTAGAGCTTGATGATTTGTTAAATGAGGACTTAAATGAGGCTGTCAAAATCAAAAA"
"AGGATTTGACAGGAATATTAATTTTATGAAGATTAAGAAAAAATTACTTCGATCATTAAAGGTGAATTGTGCTATTGTCA"
"ATGACAAAGAGGAGAGTGATTATAATAAAAGAATATCAACTACTAGAATAATATACATCATCATTGCACTTTTACAACTC"
"AGAAATTGTTCCAGAATATCAGAAGCTGTTGCTGCTATCAAGAAATTCTCTGTCAAAAAAAATCTAAATGAAAGGGTGTT"
"AGTAAAGATAGCTAAATCTGAAAAAAGAATAGTGGATAGGAAAACAAAGGAAGTATATGAAACTAAGCCAAGATATCGTG"
"AAATGATTTTCCCTCTAGCATGGGTTGATAAGAAACTATTCAAAAAAATCATAAAAGATGATCAATGGGCCAAATTCAAT"
"AACAATAAAGAACCCAGAAAACGTGTGCTTGACTACCTTTTAAATAATTTTGATTGTAATACTCATTCATTAAGATATGC"
"TGGAATTAATTTTATGTTGAATGAAAAAAAGGTTCCTATGAACATTATCGCTAAATTTGTTGGTCATGTTAATACAGAAC"
"AACTTGTTACATATACTCAACATCAAGCATTGGATGATGTTTTTGCTATGGATGTGTAAAAAGGCACCTCGATTATCCGG"
"GGTATGTAGACATTGTCTTATCTTTTTTTATCTTTTTTTATCTTTGTAATTCTGTTGTACAATGTAGGTGTTTTTGCAAA"
"GATAAACATTTTAAATGGTCATCATAGTGATTATCTCGTCTGGCTTGGCTTTATAATATTTACACATCTGATCAATGAAA"
"TTTTTGAACTCATATATACTTAAATGCCTCAAAAGTATCCTAATCACACACCATCTACCACACGTTTTAATATCATTTGC"
"TCTCTTTTGGAATTTAAATTCGTTGTAATGTAATTCATACGGACACTCTAACAGGAGTAATGATAGATATGGATAATATT"
"GGTTTGATATTTTTCTGAAATGTAGAGGAATAAATTTGAGGCTATTATCGGGATATCCTCCATAGCTATTGAAAAATTCT"
"ATGGTATTTTCATCTCTCTTGAATAAGCAACACCAGTGACCAAAGTTCTTTTTAGCTTCAAACAATAATATACATGCACC"
"ATATGGACCTAATACCTCATCAATAGAATTGTAGTTAATCAAATCTGGATACAAAACTATTTGTGCTTTATTATCTAACA"
"TACCTAAAATATCGGTATTTGAAAGGGCTACATTTTCATAATGTTTGATAGTTTTCATTTTATTATAATTATATGATAAT"
"AAAATAAAATACTTCATACAGTTAGACCATATATGTTATGCTAAATGGATTGAATCCAGAACCTCCAATACCAGTAGTAA"
"ATTGACCAAGATTATTGTCTTTGTAAACAACTATTTGACCATTTGATAATAGTGTTATTAATCCAGGATTAACTGGCCTA"
"TTTCCATCATCAATCACAAATATTTCAAAATCTACTTGAATATTGGTGGTTGGTCTTAAATCAGCTGGTAATGCTCCAAT"
"AGCTGAATTTATTACAGCTGATGATGTTGCATTTGCTTGGAAAGGAGGAAATGTTAGATTGACAAGATTATTTATTTTAG"
"TGTATGCAACATTTTGTACTAATGGTGATGCCCATGGACCTGAAAGAGATAGGGAAAATGATCCAGTTGTCAAAGAAATA"
"TTGCTAACTGCTTGAGTAATATCAGAAGCACCATACATTAAATGAGGAGGAGTAAAATTACTATTACTCCAGACTGTATT"
"AGTATTTCCTGTTGGATTTGCTGGAACATTTGTCAGAGTATTAGATTTATTATTAATGTTGTACAGATTTGGTTGTAGTA"
"ATGATGATATTGACATATATTATTATAATTAGATTCTAAATATATTTAGTGTAAATCCGCTTGCATTGGGTTGTATTTCC"
"CCTCCTGAATTTGCAAAAGCGATAAAAATATTGTCTGATGGTGTCATATCAATAATACCATTTAGAGATGCACTCATTTG"
"AATTCCAGCTCCTGAATAAATTACTGCCGTATTATAGACAGCTGTTCCACCATTTTTGAATATAGATATGATTAATGATC"
"CATCTAATGTACCGATTGAGGTACCAATATATGTTACAGCAACATAAAATGGAGCAGTTTCCGTGGTGGTGAACACACCG"
"TCGACATAGGAACAATTACCACCTAATGTTTTTGTGGTAAAAGCAACAGTACCAGTTGATACTTCTGGAATTGATGCTTG"
"CGTGCCACCACTTGTTTCATATGTCGGTAAATCTCCAGAAAAATAAGTTCCTGAACCAACTGTTCCACCTGTATTACCTT"
"TTGGACCCATTTCACCCTTAATTCCAACCCCAATATCACCTTTATCACCCTTTAACCCGTTAGTTCCGGGATCACCTTTG"
"TCACCTTTTGGACCTGATGAACCAGTACCACTATTCAAATCAGCTGAACCAAACATTAAATGAGGCGGATTAAAAGCATT"
"ATTACTCCATAAAGTATTGGATGCTGATGTTGGATTGGTGGGTAAATTTGTGAGAGAATGTGATTTAGAATTAATATTAT"
"ATGTATTTGGTTGCAATAATATTGATACAGACATAATTATATTATCAAGATGATATAATTATTTCTCATAACTAACCAGG"
"AGGAATAAAATATTGTCCTGTTATGTAAATTAAGACTGTTATTGATGTTGATGCTTGTATTTTCATACTTAACACAATCT"
"CTGGTGTAGCTGCTGTAGCTGTTACAATACCATATTGTACAACACCTGTAGATGCACCTGTTATTGAAGCTGTTCCAATC"
"ACATTATTACCATTAAAATCACCACTAGCAACTGGAATAGAAAAATATATTATTCCTTGTGCCATATTAGCAGGAATTGT"
"TGCGTTTGTACAAATACTAAATGTTACAATATTACCTATTCTCGAATAAATAGATGTTGTTGGTGAAACACTTGTAAATA"
"TTTGTGTGAATGAAACTGTTGGTGTCCAAATTCCTGATGATAATACTACTGCTGAACCTACATCACCTTTTAATCCCTTA"
"TCACCCAAATTACCTTTTAATCCATTTGTACCAGTATCTCCTTTTAAACCTTTATCTCCACTTCCTGTTTCCCCTTTTAA"
"ACCATTTATACCTGCATCACCTTTTAATCCTTTATCTCCACTCCCAGGATCTCCCTTTAATCCATTTGATCCAATATCTC"
"CTTTGAGACCATCTAAACCTGCATCACCTTTTAATCCTTTATCGCCACTTCCAGGATCTCCTTTTAATCCATTTGATCCA"
"ATATCTCCTTTTAATCCATTTGATCCAATATCTCCTTTTAATCCATTTGTTCCAGCTTCTCCTTTATCACCCTTTTCCCC"
"TTTGTCTCCACCACCACCACCGCCGTTGGATAAATCTGTGGAACCAAACATTAAATGAGGTGGATTATGAGCATTATTAC"
"TCCATATTGTATTACTCAAATTAGTGGGATTTGATGGTAAATTATTAAGAGTATGTGATTTAGAATTAATATTGTATGTA"
"TTAGGTGAAAATAATGTGGATAACGACATATATTAATATTATATTATTAAATATGATATTAATTATTCTATTTACTTCTT"
"ACTTTTGCATTTTTAATACTTTAAGTATTATTTTTTACCCTTATGATTTTTTCTACTCTGAACAGGTTTTTGCTTAGGTT"
"GTTCCTCTTCTTCTTCATCACTTTCTTGTTCAGTCATAATTTTCAATCGGTGTTTTTGGTTCTCTAATTCTTGTCGGTAT"
"GCTTTAAATTCTCTATTCATTCTTGATTTAATTTTACTTGTTCGATGTGCTCTGAATTCTCTAAGTTTTTTCTCATCATT"
"AATATCTTCAATCAAATCATCTAATTGTTCTGTTGTCATATTGTCAAATAAATTATATAACGCATCCATATCAAATGGTT"
"TTTCTACTCGTGGCATACCTCCACTATTGATCACTATCTCATTATTTTCATTATTGAATGGTGTGTAATTCATTATTATA"
"TTATATATACATATATTTTTATCCTATTTTGACACATAATAGATACTTAATCTATCCATAAATCATAATATCACGAAGTT"
"TTTTATTCATTTTTTGATAGACTTGACATACTTCTGTTTTTCTATGTTTAGGTCTATTGGATCTTGTGTATGTTTTTCCA"
"CAAAATTCACAAATCAATACATCATTTGGATGTGCTTTAACTTTTTCTTCACCATATGTTCTCCCATTGTACGAATCTTT"
"GTACACATTTTGACCATTTTTTTTCCCAATTGGACCTGGTCTTTGATTGAATCTTAATACACAAGTTGGTTGTCCAGCAT"
"CCTCATTACGAATAACTTTATTTTTATATACTGCTTTTGGTACTGGTGTTTGTATATATTTCAATTCTTTTCTATTCATT"
"CGAGTTAATTCTTTTTCTTCTGCGAAATCATATGGTATATCTCTTTTTAGCATTTAATATTACCTATAATATTTTTTTAC"
"TAGTTACTGACGGAATAGAATTAGTATTAGAATTACTCTCAAATAATAAATATATACATAGGAATTTAATTTATCAACTT"
"TTTATATAAAATAAATGTTATCCTACATAAAATATGATAAATTTAGCAAGCCTTTTGCCAAAATCAGTGGAGGGAAATAC"
"AAGGGAAAAATGGCATATGTGAATGAAGAAAATGATAAAGGACGTAATGAATTAAAGCTACCCGAGGGTAAATTTGTACC"
"ATATCCTAATCCTTTAACTAGAGAAGTAGTTTATGTAGCCGGACAAAGTGGTAGTGGTAAATCTACCTACGCAGCACAAT"
"ATATCTACAACTACAAGAAATTATTTCCAGCTAACAAGGTGTTTGTGTTTTCAAGGTTAGAAATGGATCAAATATTAGCA"
"TCACTTGGATGTATTCAAATACCTATTGATGAAGAACTATCAGAAATGGACGCAATTAGGGATATAAAGAATGCATTATG"
"TTTGTTTGACGATATTGATACAATCAAAGACAAGAATCTAAAGAATTGTGTTTATGATATTCAAAATGATATTCTTGAAA"
"CTGGACGTCATAAAAATATATATATTCTTGTCACATCCCATTTGATTAATGGTAATGATAAAAAAAATTCTAGAACTATC"
"CTCAATGAAGCCCATAAAGTGACATTCTTTCCAAAGAGTGGTTCGTATGCCATAAATTATTTCCTCAAAAACTACATTGG"
"AATACCTAAAAAAGACATAGATGAGATCTTAAAGATAAAATCAAGGTGGATCACTATCAATAAAGGTTATCCTTTGTACA"
"TATTTTATGAAACGGGGGCAAAAACTATATAAATTTTATCTTATTATTTACCCCCAACAATCTTGGGGTCGAACAATCTT"
"CGGGTATTTAATTGTCTAAAAAAAGGAATTTCGCGCCATTTAACTGATAAACAATCATAATTGATGATATTTTTACTATT"
"TACTTTGATGAAATTTCCACTAATAGTAGTAAAAATTTATATTGGACAGAAATCTAGCCAACCCTTTTCTTCTTGGTAGG"
"TTTCTTTTTGGATTTCTTCTTGGCCTTTTCTATCTCTTTCTCAGCCTTTTCTGCTTCATTCTCTAGCTTGGTAACAATTT"
"TCTTTTGAGCAAGCATTTTCTTAACTAGTTTGTCTTTTTTAACCAATAATGCCTTTAATTTTACCTGTGATGCTTTGATC"
"AATGATTTTTTCATAGTATCATCATCGACAATTAATTTAAGGTTTTTATATTGTTTAATCAATATTTTAGCATCATCCTG"
"TAATTTCTTATATTTGAGTATTTCTTTGGTCAAATCGAGTTTCTTTTTACCAGCATTCTCCAATAATTTTGGATCAACAC"
"TATATCTACCATACATCCTGACTTGATTTGCCTTAAGACACTGCTCTGGAGTACCAGCTTTTTTACCTTTCGGTATCTTT"
"CCTATACCACAATACATTTTTAAGATATAATTAGATCATAAAAATGTATAAAGATTACATATTCATTAATTCTTCCAAAA"
"TTCTTTGATCATTATTGGACATTTTGGGTGATCGTTTAGTTCTTTTGGATCCTCCTTTCAAAGATTTCTTGACAGGTTTT"
"TTCTTAGTAATTTTCTTGGTTTTACTACCAGAACTCTTTTTCTTGGTTGTTTTACCAGATTTCTTTTTCAAAGCTTCATA"
"TTGTTTCTTGGCTTTGGGACTTTGCATAGCTTCACCATATTTCATACCATGTTCTTTAGCAAATTTCTGTAAAAATGCTA"
"CCCATGGTGATTTCTTAGCACCAGCTTTTGTACCAATACCACCTTTCTTAACCCTACGTTTGACCGTTCTACCACCTGAT"
"AATACACCTGCTAAAACACCTCCTACTTCAGTGCCACAATTGGGACAAAAACATCCTCCTCTTGGAGCAGTTCCAGATAA"
  "TAATACTTTCTTAGACATAATAATATTATATGATATTATTAATAATCACGCATTTACATAATTATGATCATAATTATTGT";


 std::string phage(PSUEDO);

 int start = rand() % (phage.length() - 1000) + 500; 
 int width = 300;

 std::string to_insert = phage.substr(start, width);

 // get the center point
 int center = m_gr.Width() / 2;
 phage_site = center;
 phage_string = to_insert;

 m_seq = m_seq.substr(0, center + left_scramble.length()) + to_insert + 
   m_seq.substr(center + left_scramble.length(), m_seq.length() - center - left_scramble.length());
 
}

void SeqFrag::addIndels(size_t n) {

  if (n == 0 || m_seq.length() < 5000)
    return;

  size_t spacing = m_seq.length() / (n+1);
  spacing = std::max((size_t)5000, spacing);
  std::vector<int> breaks;
  for (size_t i = spacing; i < m_seq.length() - 5000; i += spacing) {
    breaks.push_back(i);
  }  
  breaks.push_back(m_seq.length() - 1);

  if (spacing <= 30) {
    std::cerr << "Simulated indel spacing < 30. Should be > 30, reduce number of indels" << std::endl;
    exit(EXIT_FAILURE);
  }

  if (breaks.size() < 2)
    return;

  if (m_gr.strand == '-') // flip it back to process, then flip at end
    SeqLib::rcomplement(m_seq);

  std::vector<std::string> TCGA = {"T","C","G","A"};

  // make a read sim to get random sized del
  ReadSim rs;

  // set up for the loop
  int del_cumsum = 0;
  int ins_cumsum = 0;
  std::vector<std::string> frags;
  frags.push_back(m_seq.substr(0, spacing));

  for (size_t i = 0; i < breaks.size() - 1; ++i) {

    // random size for events
    int ds = rs.getRandomIndelSize();
    
    char etype = (rand() % 2 ? 'D' : 'I');
    //etype = ds >= 50 ? 'D' ? 'I'; // events above 50 are always dels
    //char etype = 'D';

    // get the bounds
    int start = etype == 'D' ? breaks[i] + ds : breaks[i];
    int end = breaks[i+1];

    std::string ins_string = "";
    if (etype == 'I') {
      if (ds < 50) { // random sequences for small insertions
	for (int i = 0; i < ds; ++i) 
	  ins_string += TCGA[rand() % 4];
      } else { // tandem duplications for large
	int len;
	std::string chrstring = m_gr.ChrName(SeqLib::BamHeader());
	char * seq = faidx_fetch_seq(m_index, const_cast<char*>(chrstring.c_str()), m_gr.pos1 + breaks[i], m_gr.pos1 + breaks[i] + ds -1, &len);
	ins_string = std::string(seq);
	//std::cerr << ins_string.length() << " " << ds << std::endl;
      }
    }
    
    
    std::string lead_base = m_seq.substr(breaks[i]-1,1);
    std::string ref_seq = (etype == 'D' ? m_seq.substr(breaks[i], ds) : "");
    std::string alt_seq = (etype == 'D' ? "" : ins_string);

    // make the indel object
    Indel ind(ds, etype, ref_seq, alt_seq, lead_base);
    if (etype == 'D')
      ind.gr = SeqLib::GenomicRegion(m_gr.chr, m_gr.pos1 + breaks[i]-1, m_gr.pos1 + breaks[i] + ds-1);
    else
      ind.gr = SeqLib::GenomicRegion(m_gr.chr, m_gr.pos1 + breaks[i], m_gr.pos1 + breaks[i] + 1);
    ind.frag_id = frag_id;

    // check that it's not on a blank region
    if (breaks[i] < 101 || m_seq.substr(breaks[i] - 100, 200).find("N") != std::string::npos) {
      start = breaks[i]; // don't put in the del or insert
      etype = 'D';
    } else {
      // store the indel and update reference counter
      m_indels.push_back(ind);
      if (etype == 'D')
	del_cumsum += ds;
      else
	ins_cumsum += ds;
    }

    // cut the sequence out
    if (etype == 'D') {
      frags.push_back(m_seq.substr(start, end - start));
    } else {
      // make the random insertion
      frags.push_back(ins_string + m_seq.substr(start, end - start));
    }

  }

  std::string new_seq;
  for (auto& i : frags) {
    new_seq += i;
  }

  if (m_gr.strand == '-') // flip back if need be
    SeqLib::rcomplement(new_seq);
  
  m_seq = new_seq;

}

void SeqFrag::getSeqFromRef(faidx_t * findex) {

  int len;
  std::string chrstring = m_gr.ChrName(SeqLib::BamHeader());
  char * seq = faidx_fetch_seq(findex, const_cast<char*>(chrstring.c_str()), m_gr.pos1-1, m_gr.pos2/*-1*/, &len);
  
  if (!seq) {
    std::cerr << "Failed to get reference sequence at " << m_gr << std::endl;
    return;
  }
  
  m_seq = std::string(seq);

  // reverse complement if need
  if (m_gr.strand == '-') {
    SeqLib::rcomplement(m_seq); 
  }
}

int SeqFrag::getLeftSide() const {

  if (m_gr.strand == '-')
    return m_gr.pos2;
  return m_gr.pos1;

}

int SeqFrag::getRightSide() const {

  if (m_gr.strand == '-')
    return m_gr.pos1;
  return m_gr.pos2;


}

std::ostream& operator<<(std::ostream& out, const SeqFrag& s) {
  
  out << s.m_gr << "\t" << 
      s.m_seq.length() << "\t"
      << (s.right_scramble.length() ? s.right_scramble : "N");
  return out;
}
