% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-class.R
\docType{methods}
\name{plot,model,ANY-method}
\alias{plot,model,ANY-method}
\title{Plot \linkS4class{model}
 
Plots object of class \linkS4class{model} for any combination of inputs.}
\usage{
\S4method{plot}{model,ANY}(x, plotTitle = NULL, maxErr = 1, iter = NULL,
  regs, lengths, Nplot.ddG = FALSE, verticalPlots = FALSE)
}
\arguments{
\item{x}{Object of class \linkS4class{model}.}

\item{plotTitle}{Optional title parameter to be used for plot.}

\item{maxErr}{Optional parameter giving maximum error to be displayed in nucleotide affinity plot.}

\item{iter}{Iteration of beta values to be used in plot. If iteration == NULL, the most recent round of beta values are used.}

\item{regs}{Optional list containing names of different shaded regions for nucleotide and shape plots.}

\item{lengths}{Optional list containing lengths of regions in \code{regs}, corresponding to different shaded regions for nucleotide and shape plots.}

\item{Nplot.ddG}{logical: If TRUE, ddG scaling is used for nucleotide plot. If FALSE, affinity scaling is using for nucleotide plot.}

\item{verticalPlots}{logical: If TRUE, all plots are stacked vertically. If false, plots are fit into a roughly square block.}
}
\value{
ggplot plots of intercept values
}
\description{
Plot \linkS4class{model}
 
Plots object of class \linkS4class{model} for any combination of inputs.
}
