% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N-class.R
\docType{methods}
\name{plot,N,ANY-method}
\alias{plot,N,ANY-method}
\title{Returns Standardized PSAM Plot for \linkS4class{N}}
\usage{
\S4method{plot}{N,ANY}(x, Ntitle = "", maxErr = 1, iter = NULL,
  regs = NULL, lengths = NULL, ddG = FALSE)
}
\arguments{
\item{x}{Object of class \linkS4class{N}.}

\item{Ntitle}{Title for plot.}

\item{maxErr}{Maximum height of error bars to use in plotting.}

\item{iter}{Iteration of beta values to be used in plot. If iteration == NULL, the most recent round of beta values are used.}

\item{regs}{Optional parameter giving labels to use for region shading. If used, lengths parameter must also be specified.}

\item{lengths}{Length of region parameters to be included for shading.}

\item{ddG}{logical: If ddG == TRUE, ddG units are used on y-axis. If ddG == FALSE, relative affinities are used for y-axis.}
}
\value{
Ggplot dot plot of mono-nucleotide values
}
\description{
Gets PSAM dot plot from N.values slot.
}
