% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Intercept-class.R
\docType{methods}
\name{plot,Intercept,ANY-method}
\alias{plot,Intercept,ANY-method}
\title{Plot \linkS4class{Intercept}
 
Plots object of class \linkS4class{Intercept} with specific methods for multi-round fitting and view- and strand-specific offsets.}
\usage{
\S4method{plot}{Intercept,ANY}(x, sumI, includeRound, includeView,
  includeDNAstrand, rcSymmetric, title = NULL, iter = NULL)
}
\arguments{
\item{x}{Object of class \linkS4class{Intercept}.}

\item{sumI}{Intercept part of design matrix summary.}

\item{includeRound}{logical: indicating whether or not plots of ddG values for different rounds should be included. If no value is indicated, \linkS4class{Intercept} object will be used to infer whether multiple rounds were fit (includeRound = TRUE) or only one round was used (includeRound = FALSE).}

\item{includeView}{logical: indicating whether or not affinities for different views should be plotted. If no value is indicated, \linkS4class{Intercept} object will be used to infer whether individual views were fit (includeView = TRUE) or only one round was used (includeView = FALSE).}

\item{rcSymmetric}{logical: indicating whether reverse complement symmetric version of plotting should be used. If no value is indicated, \linkS4class{Intercept} object will be used to infer whether reverse complement symmetrized values were fit (rcSymmetric = TRUE) or not (rcSymmetric = FALSE).}

\item{title}{Optional title parameter to be used for plot}

\item{iter}{Iteration of beta values to be used in plot. If iteration == NULL, the most recent round of beta values are used.}

\item{includeDNAStrand}{logical: indicating whether or not affinities for different DNA strands should be plotted. If no value is indicated, \linkS4class{Intercept} object will be used to infer whether individual strands but not views were fit (includeDNAStrand = TRUE) or not (includeDNAStrand = FALSE).}
}
\value{
ggplot Plots of \linkS4class{Intercept} values
}
\description{
Plot \linkS4class{Intercept}
 
Plots object of class \linkS4class{Intercept} with specific methods for multi-round fitting and view- and strand-specific offsets.
}
