% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-class.R
\docType{class}
\name{model-class}
\alias{model-class}
\alias{model}
\title{Class \linkS4class{model} for SelexGLM}
\description{
An S4 class to represent model object to store library design, model design, and model parameters for a SelexGLM project.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name to be associated with the model object. If unspecified, empty string is assigned by default.}

\item{\code{varRegLen}}{Length of the library design for the selex data.}

\item{\code{leftFixedSeq}}{Fixed sequence to the left of random library in library design.}

\item{\code{rightFixedSeq}}{Fixed sequence to the right of random library in library design.}

\item{\code{seedLen}}{Length of k-mer used to seed the regression. If unspecified, empty numeric value is assigned by default.}

\item{\code{consensusSeq}}{Optional regular expression input specifying consensus sequence to be used to determine the seed sequence for building a PSAM from the k-mer table used to seed the analysis. If "consensusSeq" is input in iupac notation, it is converted to a standard regular expression during initialization of model object.}

\item{\code{leftFixedSeqOverlap}}{Number of bp into the left fixed flank to be considered in analysis. If unspecified, 0 is assigned by default.}

\item{\code{rightFixedSeqOverlap}}{Number of bp into the right fixed flank to be considered in analysis. If unspecified, \code{rightFixedSeqOverlap} is set to \code{leftFixedSeqOverlap} by default.}

\item{\code{affinityType}}{name of affinity variable in k-mer table to be used in building the seeding PSAM. If no value is specified, affinityType = 'Affinity'.}

\item{\code{numViews}}{number of distinct views of length k contained in each strand. Must be equal to leftFixedSeqOverlap+varRegLen+rightFixedSeqOverlap.}

\item{\code{rounds}}{list of length 1 with rounds[[1]] equal to a vector containing the rounds of data to be fit.}

\item{\code{confidenceLevel}}{view confidence level cutoff required for probes used in glm fit.}

\item{\code{minAffinity}}{minimum view affinity required for probes used in glm fit.}

\item{\code{missingValueSuppression}}{difference in ddG between the lowest fit beta values and estimates of betas for features that do not occur in the design matrix passed to glm fit.}

\item{\code{minSeedValue}}{minimum value for mono-nucleotide affinities specified in initial seeding PSAM. If no value is specified explicitly, minSeedValue = 0.}

\item{\code{regressionFormula}}{regression formula ('character' class) specifying the feature design of the 'model' object.}

\item{\code{iteration}}{number of glm iterations performed.}

\item{\code{upFootprintExtend}}{number of upstream base pairs to consider beyond the seed.}

\item{\code{downFootprintExtend}}{number of downstream base pairs to consider beyond the seed.}

\item{\code{rcSymmetric}}{boolean indicating whether of not a reverse complement symmetric model should be fit.}

\item{\code{includeDNAstrand}}{boolean indicating whether or not a strand orientation specific offset should be included in the 'model' fit. If includeView == TRUE, includeDNAstrand is ignored.}

\item{\code{includeView}}{boolean indicating whether or not a view+strand orientation specific offset should be included in the 'model' fit. If includeView == TRUE and rcSymmetric == TRUE, view offsets will be fit for only one of the two DNA strand orientations.}

\item{\code{includeShape}}{boolean indicating whether or not shape coefficients should be included in the 'model' fit.}

\item{\code{useFixedValuesOffset.N}}{logical: use initial, fixed values for mononucleotide positions within the model footprint, but not in N.set, as an offset to glm fit.}

\item{\code{useFixedValuesOffset.Shape}}{logical: use initial, fixed values for shape positions within the model footprint, but not in Shape.set, as an offset to glm fit.}

\item{\code{exUpBases}}{number of bases upstream of the mono-nucleotide position required to describe shape at the same position. If no value is specified explicitly, exUpBases = 2.}

\item{\code{exDownBases}}{number of bases downstream of the mono-nucleotide position required to describe shape at the same position. If no value is specified explicitly, exDownBases = 2.}

\item{\code{fpLen}}{footprint length of model. Must be fpLen = upFootprintExtend+seedLen+downFootprintExtend.}

\item{\code{shapeParamsUsed}}{list of length one contaning a vector of shape features to be included in 'model'. Only used if includeShape == TRUE.}

\item{\code{shapeTable}}{table of shape parameters to be used as predictors. Only used if includeShape == TRUE.}

\item{\code{features}}{object of class 'featureSet' containing specifics of model design and values for model parameters.}

\item{\code{verbose}}{logical: indicates whether to use verbose options in \pkg{SelexGLM} functions.}

\item{\code{dateInitialized}}{Character string generated by date() at the time when the object of class 'model' is created.}

\item{\code{dateBetasLastAdded}}{Character string generated by date() at the time when the object of class 'model' was last changed to incorporate new beta values.}

\item{\code{dateLastModified}}{Character string generated by date() at the time when the object of class 'model' was changed using any of the methods associated with it.}
}}

