% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKmerCountAffinities.R
\name{getKmerCountAffinities}
\alias{getKmerCountAffinities}
\title{Create k-mer affinity table for seeding GLM analysis of SELEX data.}
\usage{
getKmerCountAffinities(sample, k, markovModel, minCount = 100,
  symmetrize = TRUE)
}
\arguments{
\item{k}{K-mer length to be counted.}

\item{markovModel}{Markov model handle to use to predict previous round probabilities and expected counts.}

\item{minCount}{The minimum number of counts for a k-mer to be output.}

\item{symmetrize}{logical: indicates whether count cutoff and sorting should be imposed on the symmetrized counts/affinities.}

\item{Sample}{Sample handle to the dataset on which k-mer counting should be perfomed.}
}
\value{
A data frame containing k-mer affinities (standard and reverse complement symmetric versions).
}
\description{
Create k-mer affinity table for seeding GLM analysis of SELEX data.
}
