% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDesignMatrix.R
\name{addDesignMatrix}
\alias{addDesignMatrix}
\title{Add Design Matrix}
\usage{
addDesignMatrix(data, model)
}
\arguments{
\item{data}{Table output by \code{\link{topModelMatch}} containing probes, probe counts and information about the top binding view for each probe.}

\item{model}{Object of class \linkS4class{model} used to build design matrix from the output of \code{\link{topModelMatch}}.}
}
\value{
Data frame containing probes with design matrix built for regression input.
}
\description{
Uses top binding windows to align probes and add corresponding design matrix to \code{\link{topModelMatch}} for regression based on feature design in \linkS4class{model} object.
}
\details{
Builds a design matrix for probes in \code{data} using the features contained in \code{model}. The following features will be added for use in the glm regression:
\enumerate{
 \item \code{logProb}: log(\code{data$Probability})
 \item \code{N.Ax, N.Cx, N.Gx, N.Tx}: A nucleotide at position x is represented by a set of 4 nucleotide variables that are equal to 0 or \code{data$Round} depending on the identity of the nucleotide in question. If reverse complement symmetry is being used, contributions from x and its reverse complement symmetric equivalent nucleotide, x', are both represented by a single block of 4 nucleotides.
 \item \code{fixedNddG}: If useFixedValuesOffset.N == TRUE, fixedNddG is the ddG contribution from nucleotides not included in \code{model@features@N@N.set}. 
 \item \code{Round.R}: The round of a probe, r, is represented by a value of 1 in column \code{Round.r} and 0 in all other round columns.
 \item \code{Strand.[FR]}: If includeDNAstrand == TRUE in \code{model} input, the DNA strand of the top view is represented by (\code{data$Strand.F}, \code{data$Strand.R}) equal to 0 or \code{data$Round} depending on which strand the top view is located on. 
 \item \code{Strand.[FR]v}: If includeView == TRUE in \code{model} input, the View and strand of the top view is represented by a set of variables \code{data$Strand.[FR]v}, where v is in [1, (number of views per strand)]. These variables are equal to \code{data$Round} if the top view is the one represented by that variable, or zero if not. 
 \item \code{Shape.[shape]x}: A shape parameter at position x is represented by a single variable \code{Shape.[shape]x}, which is equal to the shapeTable lookup value for the shape parameter at position x. A variable of this kind will be included for each shape in \code{model@shapeParamsUsed[[1]]} and each position in \code{model@features@Shape@Shape.set}
}
}
