% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Shape-class.R
\docType{class}
\name{Shape-class}
\alias{Shape-class}
\alias{Shape}
\title{Class 'Shape' for Shape Feature Coefficients}
\description{
Defines an S4 class to represent shape feature coefficients.
}
\section{Slots}{

\describe{
\item{\code{seedLen}}{number of base pairs in the seeding model.}

\item{\code{Shape.upFootprintExtend}}{number of upstream positions to fit shape features beyond the seed.}

\item{\code{Shape.downFootprintExtend}}{number of downstream positions to fit shape features beyond the seed.}

\item{\code{fS.upFootprintExtend}}{maximum number of upstream positions to be fit beyond the footprint for any feature.}

\item{\code{fS.downFootprintExtend}}{maximum number of downstream positions to be fit beyond the footprint for any feature.}

\item{\code{fpLen}}{footprint length for full set of features.}

\item{\code{Shape.set}}{set of positions for which shape coefficients are fit where positions are given relative to the full feature set footprint.}

\item{\code{Shape.equivMat}}{matrix encoding reverse complement symmetries between positions with -1 at Shape.equivMat[position1, position2] entry. All other entries are 0.}

\item{\code{Shape.values}}{beta values for positions in Shape.set.}

\item{\code{Shape.errors}}{beta value errors for positions in Shape.set.}

\item{\code{Shape.z}}{beta value z scores for positions in Shape.set.}

\item{\code{Shape.sig}}{beta value significance for positions in Shape.set.}

\item{\code{Shape.oldValues}}{previous iteration beta values for positions in Shape.set.}

\item{\code{Shape.oldErrors}}{previous iteration beta values' errors for positions in Shape.set.}

\item{\code{Shape.oldZ}}{previous iteration beta values' z scores for positions in Shape.set.}

\item{\code{Shape.oldSig}}{previous iteration beta values' significance for positions in Shape.set.}
}}

