% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N-class.R
\docType{class}
\name{N-class}
\alias{N-class}
\alias{N}
\title{Class 'N' for Mononucleotide Features}
\description{
Defines an S4 class to represent mononuclueotide features.
}
\section{Slots}{

\describe{
\item{\code{seedLen}}{number of base pairs in the seeding model.}

\item{\code{N.upFootprintExtend}}{number of upstream nucleotides to fit beyond the seed.}

\item{\code{N.downFootprintExtend}}{number of downstream nucleotides to fit beyond the seed.}

\item{\code{fS.upFootprintExtend}}{maximum number of upstream positions to be fit beyond the footprint for any feature.}

\item{\code{fS.downFootprintExtend}}{maximum number of downstream positions to be fit beyond the footprint for any feature.}

\item{\code{fpLen}}{footprint length for full set of features.}

\item{\code{N.set}}{set of positions for which mononucleotides are fit where positions are given relative to the full feature set footprint.}

\item{\code{N.equivMat}}{matrix encoding reverse complement symmetries between positions with -1 and identical beta values shared between positions with 1.}

\item{\code{N.values}}{beta values for positions in N.set.}

\item{\code{N.errors}}{beta value errors for positions in N.set.}

\item{\code{N.z}}{beta value z scores for positions in N.set.}

\item{\code{N.sig}}{beta value significance for positions in N.set.}

\item{\code{N.oldValues}}{previous iteration beta values for positions in N.set.}

\item{\code{N.oldErrors}}{previous iteration beta values' errors for positions in N.set.}

\item{\code{N.oldZ}}{previous iteration beta values' z scores for positions in N.set.}

\item{\code{N.oldSig}}{previous iteration beta values' significance for positions in N.set.}
}}

