library(scales)

readAndRemoveChrM <- function(fileName){
  raw <- read.table(fileName)
  return(subset(raw, raw[,1]!='chrM'))
}


####################
setwd("/Users/acd13/Desktop/ATAC/Analysis/conservation")


# read in the data, being sure to sort by gene name (which when I generated the coverage data I amde sure was unique and descriptive)
# conservation scores were generated by: intersectBed -a <score bedGraph> -b <region of interest bed> | coverageBed -a - -b <region of interest bed> | awk '{if($NF > 0.5) print $0}' | sortBed -i - | mapBed -a - -b <score bedGraph> -c 4 -o mean 
metaATACPeaks <- readAndRemoveChrM('allRepsAllButL1MetaPeaks_smartMerged300bpSummitDist.bed_mergedAllOverlaps_medianPhastCons7way.noRefSeqExons.noRepeats.Score_min0.5Overlap.bed_anyExonOrExtPromRemoved.bed')

metaAllEnh <- readAndRemoveChrM('./histoneModsAsControl/EE_L3_YA_combinedAllEnh_includingRepEnh13.bed_mergedAllOverlaps_medianPhastCons7way.noRefSeqExons.noRepeats.Score_min0.5Overlap.bed_anyExonOrExtPromRemoved.bed')
metaH3K27ac <- readAndRemoveChrM('./histoneModsAsControl/EE_L3_YA_H3K27ac_combinedConsensusReps.narrowPeak_mergedAllOverlaps_medianPhastCons7way.noRefSeqExons.noRepeats.Score_min0.5Overlap.bed_anyExonOrExtPromRemoved.bed')
metaH3K4me1 <- readAndRemoveChrM('./histoneModsAsControl/EE_L3_YA_H3K4me1_combinedConsensusReps.narrowPeak_mergedAllOverlaps_medianPhastCons7way.noRefSeqExons.noRepeats.Score_min0.5Overlap.bed_anyExonOrExtPromRemoved.bed')

genomeWideMedian <- readRDS("distalAndNonCodingWideMedianPhastConsScore.rds")

# now normalize all values to be relative to the genomewide median
atacNormd <- log2(metaATACPeaks[,ncol(metaATACPeaks)]/genomeWideMedian)
allNormd <- log2(metaAllEnh[,ncol(metaAllEnh)]/genomeWideMedian)
k27Normd <- log2(metaH3K27ac[,ncol(metaH3K27ac)]/genomeWideMedian)
k4Normd <- log2(metaH3K4me1[,ncol(metaH3K4me1)]/genomeWideMedian)


pdf('conservationMetaPeaksAllHMPeaks_NonMerged_noOutliers.pdf', width=5, height=5)
  boxplot(list(atacNormd,k4Normd,k27Normd,allNormd),
    , notch=T
    , col=c('goldenrod2',alpha('blue','red','orangered')
    , names=c('ATAC-seq','H3K4me1', 'H3K27ac','chromHMM predicted enh')
    , ylab='Log2(Median PhastCons score / distal and non-coding genome median)'
    , outline=FALSE
  )
dev.off()

allKSTest <- ks.test(atacNormd,allNormd)
format.pval(allKSTest$p.value,6,1e-323)

k27KSTest <- ks.test(atacNormd,k27Normd)
format.pval(k27KSTest$p.value,6,1e-323)

k4KSTest <- ks.test(atacNormd,k4Normd)
format.pval(k4KSTest$p.value,6,1e-323)
