# this program takes the files generated by:
# /Users/acd13/Desktop/ATAC/Analysis/tfs/getInsertSizesAndCountsInTfPeaks_forAllStages.sh
# and generates rough plots
# it will be worthwhile to come back and make these prettier

#=========================================================================================
# set up functions
#=========================================================================================
# I moved them all to their own file 
source('/Users/acd13/Desktop/ATAC/Analysis/tfs/plottingAtacInsertSizesAndEnrichmentInTfPeaks_supportFunctions.R')

#=========================================================================================
# Begin processing
#=========================================================================================
# parameter setting

args <- commandArgs(trailingOnly = TRUE)
stageOfInterest = args[1]

toAvoidZero <- 0.1 # gets added to values before dividing, to avoid infinities in Log2

allStages <- c("EE", "L3", "YA")
if(! any(grepl(stageOfInterest, allStages)) ){
  warning("Wrong stage provided, must be one of EE, L3, YA")
  quit('no', 13)
}

allSamples <- c(allStages, "gDNAControl")

setwd(paste0("/Users/acd13/Desktop/ATAC/Analysis/tfs/qualityTfs/insertSizeStatsAtPeaks/TFPeakSummits/", stageOfInterest))

allStageSizeListFile <- "perTFPeakAllStageATACInsertSize.list.rds"
allStageEnrichmentListFile <- "perTFPeakAllStageATACEnrichment.list.rds"
tfNamesFile <- "orderedListOfTFNames.tsv"

if(file.exists(allStageSizeListFile) & file.exists(allStageEnrichmentListFile) & file.exists(tfNamesFile)){
  print("Using pre-saved data")
  allStageSizeList <- readRDS(allStageSizeListFile)
  allStageEnrichmentList <- readRDS(allStageEnrichmentListFile)
  tfNames <- read.csv(tfNamesFile, sep="\t", header=F)[,1]

}else{
  print("Loading and processing data")
  
  allStageSizeList <- allStageEnrichmentList <- list()
  
  sizeDir="./rawResults/perTfPeak/insertSizes/"
  countsDir <- paste0("./rawResults/perTfPeak/counts/")
  controlCountsDir <- paste0(countsDir, "gDNAControl")
  
  # the first thing we'll do is read in the total counts for each stage
  # this will allow us to change all counts to per million mapped reads
  totalCounts <- vector(mode='numeric', length = length( allSamples))
  names(totalCounts) <- allSamples
  for (i in 1:length(totalCounts)){
    totalCountFile <- paste0("./rawResults/", allSamples[i], "AtacInsertSiteTotal.txt")
    totalCounts[i] <- read.csv(totalCountFile, header=F)[1,1]
  }
  
  # now we'll get the counts for the control data, that way for the
  # subsequent stages, we can just store the enrichment values, instead of the counts
  
  controlPMMData <- getPerMillionMappedData(controlCountsDir, totalCounts[grep('gDNAControl', names(totalCounts))])
  print("Control data loaded.")
  
  for (i in 1:length(allStages)){
    print(paste0("Loading data for ", allStages[i], "..."))
    stage = allStages[i]
    stageSizeDir <- paste0(sizeDir, stage)
    stageCountsDir <- paste0(countsDir, stage)

    allStageSizeList[[i]] <- getMedianInsertList(stageSizeDir)
    
    allStageEnrichmentList[[i]] <- getEnrichmentData(stageCountsDir, totalCounts[grep(stage, names(totalCounts))], controlPMMData)
  }
  
  tfNames <- names(allStageSizeList[[grep(stageOfInterest, allStages)]])
             
  print("Checking data...")
  
  # Now I want to run some tests to make sure that we got what we expected
  if(length(allStageSizeList[[1]]) == 0 | length(allStageSizeList[[1]]) != length(allStageEnrichmentList[[1]]) ){
     warning("Differing number of TFs found for size and enrichment")
    quit('no', 13)
  }
  
  if(length(allStageSizeList[[1]]) != length(tfNames) ){
     warning(paste0("Differing number of TFs found for size and names list. Size list is ", length(allStageSizeList[[1]]), " long, and the TF names list is ", length(tfNames)))
    quit('no', 13)
  }
  
  for ( j in 2:length(allStages)){
    if( length(allStageSizeList[[1]]) != length(allStageSizeList[[j]]) | length(allStageEnrichmentList[[1]]) != length(allStageEnrichmentList[[j]]) ){
      warning(paste0("Differing number of files found for separate stages. Comparison was: ", allStages[1], " to ", allStages[j]))
      quit("no", 13)
    }
    if( all(names(allStageSizeList[[1]]) != names(allStageSizeList[[j]])) | all(names(allStageEnrichmentList[[1]]) != names(allStageEnrichmentList[[j]]) ) ){
      warning(paste0("Differing names found for separate stages. Comparison was: ", allStages[1], " to ", allStages[j]))
      quit("no", 13)
    }
  }

  print("Saving processed data...")
  
  # now that we have everything we want, let's save things
  saveRDS(allStageSizeList, file = allStageSizeListFile)
  saveRDS(allStageEnrichmentList, file = allStageEnrichmentListFile)
  write.table(tfNames, file=tfNamesFile, sep="\t", quote=F, row.names=F, col.names=F)
}

print("Finished successfully")
